/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.xpathparser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.xpathparser.ParseException;
import org.eclipse.birt.report.model.util.xpathparser.TokenMgrError;
import org.eclipse.birt.report.model.util.xpathparser.XDepthParser;

public class XPathParser {
    private static final int INVALID = 0;
    private static final int ELEMENT = 1;
    private static final int SLOT = 2;
    private static final int PROPERTY = 4;
    private static final int VALUE = 16;
    private static final int STRUCTURE = 32;
    private CachedMemberRef ref = null;
    private DesignElementHandle currentElement = null;
    private ModuleHandle module = null;
    private int valueType = 0;
    private int slotID = -1;
    private String propertyName = null;

    public XPathParser(ModuleHandle module) {
        this.module = module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(String input) {
        XDepthParser parser_1 = new XDepthParser(input);
        try {
            parser_1.parse();
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            return null;
        }
        List depthInfo = parser_1.getDepthInfo();
        int index = -1;
        this.currentElement = this.module;
        int lastValueType = 0;
        int i = 0;
        while (i < depthInfo.size()) {
            block21: {
                String attrValue;
                String tagName;
                block24: {
                    int typeCode;
                    ElementDefn elementDefn;
                    String attrName;
                    block23: {
                        block22: {
                            block20: {
                                XDepthParser.DepthInfo oneDepth = (XDepthParser.DepthInfo)depthInfo.get(i);
                                lastValueType = this.valueType;
                                this.valueType = XPathParser.getNextValueType(this.valueType);
                                tagName = oneDepth.getTagName();
                                index = oneDepth.getIndex();
                                attrName = oneDepth.getPropertyName();
                                attrValue = oneDepth.getPropertyValue();
                                elementDefn = (ElementDefn)this.currentElement.getDefn();
                                if (i != 0 || !tagName.equalsIgnoreCase(elementDefn.getXmlName()) || this.module != this.currentElement) break block20;
                                this.valueType = 1;
                                break block21;
                            }
                            if ((this.valueType & 0x10) == 0 || tagName == null || !tagName.equalsIgnoreCase("value")) break block22;
                            this.valueType = 16;
                            break block21;
                        }
                        if ((this.valueType & 2) == 0) break block23;
                        this.slotID = this.getSlotId(elementDefn, tagName, true);
                        if (this.slotID == -1) break block23;
                        this.valueType = 2;
                        break block21;
                    }
                    if ((this.valueType & 1) == 0) break block24;
                    if (lastValueType != 2) {
                        this.slotID = XPathParser.getSlotId(elementDefn, tagName);
                        if (this.slotID != -1) {
                            this.valueType = 1;
                        }
                    }
                    if (lastValueType == 4 && this.propertyName != null && ((typeCode = elementDefn.getProperty(this.propertyName).getTypeCode()) == 23 || typeCode == 24)) {
                        this.valueType = 1;
                    }
                    if (this.valueType != 1 || attrName != null && !"id".equalsIgnoreCase(attrName) && !"slotName".equalsIgnoreCase(attrName)) break block24;
                    this.currentElement = this.findElement(tagName, attrName, attrValue);
                    if (this.currentElement == null) {
                        this.valueType = 0;
                        break;
                    }
                    if ("slotName".equalsIgnoreCase(attrName)) {
                        this.slotID = this.getSlotId(this.currentElement.getDefn(), attrValue, false);
                        if (this.slotID != -1) {
                            this.valueType = 2;
                        }
                    }
                    break block21;
                }
                if ((this.valueType & 0x20) != 0 && XPathParser.isStructureTag(tagName)) {
                    this.valueType = 32;
                    this.ref = this.parsePropertyValue(tagName, attrValue, index);
                }
                if (((this.valueType & 1) != 0 || (this.valueType & 4) != 0) && XPathParser.isPropertyTag(tagName)) {
                    this.valueType = 4;
                    this.ref = this.parsePropertyValue(tagName, attrValue, index);
                }
                if (this.valueType == 0) break;
            }
            ++i;
        }
        switch (this.valueType) {
            case 2: {
                return this.currentElement.getSlot(this.slotID);
            }
            case 1: {
                return this.currentElement;
            }
            case 4: 
            case 32: {
                return this.getRespectivePropertyHandle(index);
            }
            case 16: {
                if (lastValueType != 4) {
                    return null;
                }
                Object temp = this.getRespectivePropertyHandle(-1);
                assert (temp instanceof PropertyHandle);
                return ((PropertyHandle)temp).get(index);
            }
        }
        return null;
    }

    private static int getSlotId(IElementDefn defn, String tagName) {
        int j = 0;
        while (j < defn.getSlotCount()) {
            SlotDefn slot = (SlotDefn)defn.getSlot(j);
            if (XPathParser.isContentType(slot, tagName)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int getSlotId(IElementDefn defn, String slotName, boolean isXmlName) {
        int j = 0;
        while (j < defn.getSlotCount()) {
            SlotDefn slot = (SlotDefn)defn.getSlot(j);
            String name = null;
            name = isXmlName ? slot.getXmlName() : slot.getName();
            if (slotName.equalsIgnoreCase(name)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private static int getNextValueType(int tmpValueType) {
        int retValueType = 0;
        switch (tmpValueType) {
            case 2: {
                retValueType = 1;
                break;
            }
            case 1: {
                retValueType = 39;
                break;
            }
            case 4: {
                retValueType = 53;
                break;
            }
            case 32: {
                retValueType = 4;
                break;
            }
            default: {
                retValueType = 7;
            }
        }
        return retValueType;
    }

    private Object getRespectivePropertyHandle(int index) {
        if (this.ref == null) {
            if (this.propertyName == null) {
                return null;
            }
            return new PropertyHandle(this.currentElement, this.propertyName);
        }
        switch (this.ref.refType) {
            case 0: {
                return new PropertyHandle(this.currentElement, this.ref.getPropDefn());
            }
            case 5: {
                PropertyHandle propHandle = new PropertyHandle(this.currentElement, this.ref.getPropDefn());
                if (index < 0 || index >= propHandle.getListValue().size()) {
                    return null;
                }
                return propHandle.getAt(index < 0 ? 0 : index);
            }
            case 3: {
                PropertyHandle propHandle = new PropertyHandle(this.currentElement, this.ref.getPropDefn());
                StructureHandle structHandle = ((Structure)propHandle.getValue()).getHandle(propHandle);
                MemberHandle memberHandle = structHandle.getMember(this.ref.getMemberDefn().getName());
                if (index < 0 || index >= memberHandle.getListValue().size()) {
                    return null;
                }
                return memberHandle.getAt(index < 0 ? 0 : index);
            }
        }
        return null;
    }

    private CachedMemberRef parsePropertyValue(String tagName, String propName, int index) {
        if (this.propertyName == null) {
            IElementPropertyDefn propDefn = this.currentElement.getPropertyDefn(propName);
            if (propDefn == null) {
                return null;
            }
            this.propertyName = propName;
            if (propDefn.getTypeCode() == 16) {
                this.ref = new CachedMemberRef((ElementPropertyDefn)propDefn);
            }
            return this.ref;
        }
        if (this.ref == null && this.propertyName != null && "key".equalsIgnoreCase(propName)) {
            String newPropName = String.valueOf(this.propertyName) + "ID";
            ElementDefn elementDefn = (ElementDefn)this.currentElement.getDefn();
            IElementPropertyDefn propDefn = elementDefn.getProperty(newPropName);
            this.propertyName = propDefn != null ? newPropName : null;
            return null;
        }
        if (this.ref == null && this.propertyName != null && "simple-property-list".equalsIgnoreCase(tagName)) {
            ElementDefn elementDefn = (ElementDefn)this.currentElement.getDefn();
            IElementPropertyDefn propDefn = elementDefn.getProperty(propName);
            if (propDefn == null) {
                return null;
            }
            this.propertyName = propName;
            if (index > 0 && propDefn.getTypeCode() == 20) {
                this.ref = new CachedMemberRef((ElementPropertyDefn)propDefn, index - 1 < 0 ? 0 : index - 1);
            }
            return this.ref;
        }
        assert (this.ref != null);
        if (this.ref.refType == 0 && "structure".equalsIgnoreCase(tagName)) {
            ElementDefn elementDefn = (ElementDefn)this.currentElement.getDefn();
            IElementPropertyDefn propDefn = elementDefn.getProperty(this.ref.getPropDefn().getName());
            this.ref = new CachedMemberRef((ElementPropertyDefn)propDefn, index < 0 ? 0 : index);
            return this.ref;
        }
        if (this.ref.refType == 0 && "list-property".equalsIgnoreCase(tagName)) {
            this.ref = new CachedMemberRef((MemberRef)this.ref, propName);
            return this.ref;
        }
        if (this.ref.refType == 1 && "structure".equalsIgnoreCase(tagName)) {
            this.ref = new CachedMemberRef((MemberRef)this.ref, index < 0 ? 0 : index);
            return this.ref;
        }
        return null;
    }

    private static boolean isContentType(SlotDefn slot, String elementDefnName) {
        List tmpElementDefns = slot.getContentElements();
        int i = 0;
        while (i < tmpElementDefns.size()) {
            ElementDefn tmpContentDefn = (ElementDefn)tmpElementDefns.get(i);
            if (elementDefnName.equalsIgnoreCase(tmpContentDefn.getXmlName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DesignElementHandle findElement(String contentDefnName, String attrName, String attrValue) {
        long id = 0L;
        if ("id".equalsIgnoreCase(attrName)) {
            try {
                id = Long.parseLong(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (this.slotID != -1) {
            SlotHandle slot = this.currentElement.getSlot(this.slotID);
            int i = 0;
            while (i < slot.getCount()) {
                DesignElementHandle tmpElement = slot.get(i);
                ElementDefn tmpDefn = (ElementDefn)tmpElement.getDefn();
                if ((0L == id || tmpElement.getID() == id) && tmpDefn.getXmlName().equalsIgnoreCase(contentDefnName)) {
                    return tmpElement;
                }
                ++i;
            }
        }
        PropertyHandle prop = this.currentElement.getPropertyHandle(this.propertyName);
        if (this.propertyName != null && prop != null) {
            List contents = prop.getContents();
            int i = 0;
            while (i < contents.size()) {
                DesignElementHandle tmpElement = (DesignElementHandle)contents.get(i);
                ElementDefn tmpDefn = (ElementDefn)tmpElement.getDefn();
                if ((0L == id || tmpElement.getID() == id) && tmpDefn.getXmlName().equalsIgnoreCase(contentDefnName)) {
                    return tmpElement;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isStructureTag(String tagName) {
        return "structure".equalsIgnoreCase(tagName);
    }

    private static boolean isPropertyTag(String tagName) {
        if (tagName == null) {
            return true;
        }
        if ("property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("list-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("method".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("expression".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("encrypted-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("text-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("html-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("xml-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("simple-property-list".equalsIgnoreCase(tagName)) {
            return true;
        }
        return "ex-property".equalsIgnoreCase(tagName);
    }
}

