/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.HashMap;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class LineNumberInfo {
    private HashMap elementMap = new HashMap();
    private HashMap slotMap = null;
    private HashMap includeLibStructMap = new HashMap();
    private HashMap embeddedImageStructMap = new HashMap();
    private HashMap includedCssStyleSheetStructMap = new HashMap();
    private int themeProp = 1;

    public LineNumberInfo() {
        this.slotMap = new HashMap();
    }

    public void put(Object obj, Integer lineNo) {
        if (obj instanceof PropertyDefn) {
            this.themeProp = lineNo == null ? 1 : lineNo;
        } else if (obj instanceof DesignElement) {
            this.elementMap.put(new Long(((DesignElement)obj).getID()), lineNo);
        } else if (obj instanceof IncludedLibrary) {
            this.includeLibStructMap.put(((IncludedLibrary)obj).getNamespace(), lineNo);
        } else if (obj instanceof EmbeddedImage) {
            this.embeddedImageStructMap.put(((EmbeddedImage)obj).getName(), lineNo);
        } else if (obj instanceof IncludedCssStyleSheet) {
            this.includedCssStyleSheetStructMap.put(((IncludedCssStyleSheet)obj).getFileName(), lineNo);
        } else if (obj instanceof ContainerContext) {
            String xpath = LineNumberInfo.convertSlotContextToXPath((ContainerContext)obj, ((ContainerContext)obj).getElement().getRoot());
            if (xpath == null) {
                assert (false);
                return;
            }
            this.slotMap.put(xpath, lineNo);
        } else {
            return;
        }
    }

    public int get(Object obj) {
        Module tmpModule = null;
        if (obj instanceof EmbeddedImage) {
            return this.intValue((Integer)this.embeddedImageStructMap.get(((EmbeddedImage)obj).getName()));
        }
        if (obj instanceof Theme && (tmpModule = ((Theme)obj).getRoot()) instanceof Library && ((Library)tmpModule).getHost() != null) {
            return this.themeProp;
        }
        if (obj instanceof Library && ((Library)obj).getHost() != null) {
            return this.intValue((Integer)this.includeLibStructMap.get(((Library)obj).getNamespace()));
        }
        if (obj instanceof IncludedCssStyleSheet) {
            return this.intValue((Integer)this.includedCssStyleSheetStructMap.get(((IncludedCssStyleSheet)obj).getFileName()));
        }
        if (obj instanceof DesignElement) {
            return this.getElementLineNo(((DesignElement)obj).getID());
        }
        if (obj instanceof ContainerContext) {
            return this.getSlotLineNo((ContainerContext)obj);
        }
        return 1;
    }

    private int getSlotLineNo(ContainerContext obj) {
        String xpath = LineNumberInfo.convertSlotContextToXPath(obj, obj.getElement().getRoot());
        if (xpath == null) {
            assert (false);
            return 1;
        }
        return this.intValue((Integer)this.slotMap.get(xpath));
    }

    public int getElementLineNo(long id) {
        return this.intValue((Integer)this.elementMap.get(new Long(id)));
    }

    int intValue(Integer obj) {
        return obj == null ? 1 : obj;
    }

    public static String convertSlotContextToXPath(ContainerContext context, Module module) {
        if (!context.isROMSlot()) {
            return null;
        }
        SlotHandle slot = new SlotHandle(context.getElement().getHandle(module), context.getSlotID());
        return XPathUtil.getXPath(slot);
    }
}

