/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.parser.RecoverDataGroupUtil;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleParserHandler
extends XMLParserHandler {
    protected DesignSession session = null;
    protected Module module = null;
    protected String fileName = null;
    int versionNumber = 0;
    boolean isCurrentVersion = false;
    protected boolean markLineNumber = true;
    protected HashMap tempLineNumbers = null;
    protected HashMap tempValue = new HashMap();
    protected List unhandleIDElements = new ArrayList();
    private List unnamedReportItems = new ArrayList();
    private List unresolvedListingElements = new ArrayList();
    private List extendedItemList = new ArrayList();
    protected Map<String, Library> reloadLibs = new HashMap<String, Library>();
    protected boolean isReadOnlyModuleProperties = false;

    protected ModuleParserHandler(DesignSession theSession, String fileName) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
    }

    protected ModuleParserHandler(DesignSession theSession, String fileName, Map<String, Library> reloadLibs) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
        this.reloadLibs = reloadLibs;
    }

    String getFileName() {
        return this.fileName;
    }

    public boolean isVersion(int toCompare) {
        return this.versionNumber == toCompare;
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState.startElement(qName);
        newState.parseAttrs(atts);
        AbstractParseState jumpToState = newState.jumpTo();
        if (jumpToState != null) {
            this.pushState(jumpToState);
            return;
        }
        newState.setElementName(qName);
        this.pushState(newState);
    }

    @Override
    public void endDocument() throws SAXException {
        ModuleOption options;
        super.endDocument();
        this.tempValue = null;
        if (this.versionNumber < 3021300) {
            List handledExceptions = this.handleInvalidName(this.getErrorHandler().getErrors());
            this.getErrorHandler().getErrors().removeAll(handledExceptions);
        }
        this.handleUnresolveListingElements();
        this.module.getAllExceptions().addAll(this.getErrorHandler().getErrors());
        List libraries = this.module.getAllLibraries();
        for (Library library : libraries) {
            Exception fatalException;
            if (library.isValid() || (fatalException = ModelUtil.getFirstFatalException(library.getAllExceptions())) == null) continue;
            XMLParserException exception = this.errorHandler.semanticError(fatalException);
            this.module.getAllExceptions().add(exception);
        }
        if (!this.module.getAllErrors().isEmpty() || this.module.getFatalException() != null) {
            this.module.setValid(false);
            ArrayList allExceptions = new ArrayList();
            allExceptions.addAll(this.module.getAllExceptions());
            allExceptions.addAll(this.errorHandler.getWarnings());
            DesignFileException exception = new DesignFileException(this.module.getFileName(), allExceptions);
            throw new SAXException((Exception)((Object)exception));
        }
        if (!this.unhandleIDElements.isEmpty()) {
            this.handleID();
            this.unhandleIDElements = null;
        }
        if (!this.unnamedReportItems.isEmpty() && this.versionNumber <= 3021200) {
            this.handleUnnamedReportItems();
        }
        if (this.versionNumber <= 3021300 && StringUtil.isBlank(this.module.getNamespace())) {
            ((ModuleNameHelper)this.module.getNameHelper()).clearCachedLevels();
        }
        if (this.markLineNumber && this.tempLineNumbers != null) {
            this.handleLineNumber();
        }
        if ((options = this.module.getOptions()) == null || options.useSemanticCheck()) {
            this.module.semanticCheck(this.module);
        }
        if (this.errorHandler.getWarnings() != null) {
            this.module.getAllExceptions().addAll(this.errorHandler.getWarnings());
        }
        if (!this.extendedItemList.isEmpty()) {
            this.module.getVersionManager().setHasExtensionCompatibilities(this.handleExtendedItemCompatibility());
        }
    }

    private boolean handleExtendedItemCompatibility() {
        assert (!this.module.isReadOnly());
        List errorList = this.module.getAllExceptions();
        boolean hasCompatibilities = false;
        int i = 0;
        while (i < this.extendedItemList.size()) {
            ExtendedItem element = (ExtendedItem)this.extendedItemList.get(i);
            ExtendedItem.StatusInfo status = element.checkCompatibility(this.module);
            assert (status != null);
            errorList.addAll(status.getErrors());
            if (!hasCompatibilities && status.hasCompatibilities()) {
                hasCompatibilities = true;
            }
            ++i;
        }
        this.module.getActivityStack().flush();
        this.module.setSaveState(0);
        return hasCompatibilities;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    private void handleID() {
        int i = 0;
        while (i < this.unhandleIDElements.size()) {
            DesignElement element = (DesignElement)this.unhandleIDElements.get(i);
            if (element.getExtendsElement() == null) {
                if (element.getRoot() == this.module) {
                    assert (element.getID() == 0L);
                    element.setID(this.module.getNextID());
                    this.module.addElementID(element);
                }
            } else {
                this.module.manageId(element, true);
            }
            ++i;
        }
    }

    private void handleUnnamedReportItems() {
        int i = 0;
        while (i < this.unnamedReportItems.size()) {
            DesignElement element = (DesignElement)this.unnamedReportItems.get(i);
            ModelUtil.addElement2NameSpace(this.module, element);
            ++i;
        }
    }

    private List handleInvalidName(List exceptions) {
        ArrayList<Exception> handledExceptions = new ArrayList<Exception>();
        ArrayList<DesignElement> processElements = new ArrayList<DesignElement>();
        int i = 0;
        while (i < exceptions.size()) {
            Exception exception;
            Exception tmpObj = (Exception)exceptions.get(i);
            if (tmpObj instanceof XMLParserException && (exception = ((XMLParserException)tmpObj).getException()) instanceof NameException) {
                NameException nameException = (NameException)((Object)exception);
                DesignElement tmpElement = nameException.getElement();
                if (tmpElement.getName() != null && nameException.getErrorCode() == "Error.NameException.INVALID_NAME") {
                    String newName;
                    String oldName = nameException.getName();
                    if (!oldName.equals(newName = NamePropertyType.validateName(oldName))) {
                        tmpElement.setName(newName);
                        int ns = ((ElementDefn)tmpElement.getDefn()).getNameSpaceID();
                        if (ns != -1) {
                            new NameExecutor(tmpElement).getNameSpace(this.module).rename(tmpElement, oldName, newName);
                        }
                        processElements.add(tmpElement);
                        handledExceptions.add(tmpObj);
                    }
                } else if (processElements.contains(tmpElement)) {
                    handledExceptions.add(tmpObj);
                }
            }
            ++i;
        }
        return handledExceptions;
    }

    private void handleUnresolveListingElements() {
        int i = 0;
        while (i < this.unresolvedListingElements.size()) {
            ListingElement tmpElement = (ListingElement)this.unresolvedListingElements.get(i);
            RecoverDataGroupUtil.checkListingGroup(tmpElement, this);
            ++i;
        }
    }

    private void handleLineNumber() {
        for (Map.Entry entry : this.tempLineNumbers.entrySet()) {
            Object key = entry.getKey();
            this.module.addLineNo(key, (Integer)entry.getValue());
        }
        this.tempLineNumbers.clear();
        this.tempLineNumbers = null;
    }

    protected final void buildModuleOptions(ModuleOption options) {
        assert (this.module != null);
        if (options == null) {
            this.markLineNumber = true;
            this.isReadOnlyModuleProperties = false;
        } else {
            this.markLineNumber = options.markLineNumber();
            Boolean isSimple = (Boolean)options.getProperty("readOnlyModuleProperties");
            if (isSimple != null && isSimple.booleanValue()) {
                this.isReadOnlyModuleProperties = true;
                options.setSemanticCheck(false);
            } else {
                this.isReadOnlyModuleProperties = false;
            }
        }
        if (this.markLineNumber) {
            this.module.initLineNoMap();
            this.tempLineNumbers = new HashMap();
        }
        if (this.isReadOnlyModuleProperties) {
            this.module.setReadOnly();
        }
    }

    final void addUnnamedReportItem(DesignElement element) {
        assert (element instanceof ReportItem);
        if (!this.unnamedReportItems.contains(element)) {
            this.unnamedReportItems.add(element);
        }
    }

    final void addUnresolveListingElement(ListingElement element) {
        if (!this.unresolvedListingElements.contains(element)) {
            this.unresolvedListingElements.add(element);
        }
    }

    final void addExtendedItem(ExtendedItem element) {
        this.extendedItemList.add(element);
    }

    static class ModuleLexicalHandler
    implements LexicalHandler {
        ModuleParserHandler handler = null;

        ModuleLexicalHandler(ModuleParserHandler handler) {
            this.handler = handler;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        public void endCDATA() throws SAXException {
            AbstractParseState tmpState = this.handler.topState;
            tmpState.setIsCDataSection(true);
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }
    }
}

