/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class StructPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(StructPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.struct";

    public StructPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 16;
    }

    public String getName() {
        return "structure";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (defn.isList()) {
            if (value instanceof List && ((List)value).isEmpty()) {
                return value;
            }
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
        }
        if (value instanceof Structure) {
            Iterator iter = ((Structure)value).getDefn().propertiesIterator();
            while (iter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)iter.next();
                if (memberDefn.isList()) continue;
                Object propValue = ((Structure)value).getProperty(module, memberDefn);
                memberDefn.validateValue(module, propValue);
            }
            return value;
        }
        logger.log(Level.WARNING, "The value of this structure property is not a valid type");
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof ArrayList) {
            return ((ArrayList)value).size();
        }
        return 1;
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

