/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class NumberPropertyType
extends PropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.number";
    private static final NumberFormat formatter = NumberFormat.getNumberInstance(DEFAULT_LOCALE);

    static {
        formatter.setGroupingUsed(false);
    }

    public NumberPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 1);
    }

    public Object validateXml(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 1);
        }
    }

    public int getTypeCode() {
        return 1;
    }

    public String getName() {
        return "number";
    }

    public double toDouble(Module module, Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return ((BigDecimal)value).doubleValue();
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return formatter.format(((BigDecimal)value).doubleValue());
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return ((BigDecimal)value).intValue();
    }

    public BigDecimal toNumber(Module module, Object value) {
        if (value instanceof String) {
            try {
                return new BigDecimal(formatter.parse((String)value).doubleValue());
            }
            catch (ParseException parseException) {
                return new BigDecimal(0.0);
            }
        }
        return (BigDecimal)value;
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(ThreadResources.getLocale().toLocale());
        return formatter.format(((BigDecimal)value).doubleValue());
    }

    public Object validateInputString(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(ThreadResources.getLocale().toLocale());
        Number number = null;
        try {
            number = formatter.parse(value);
        }
        catch (ParseException parseException) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 1);
        }
        return new BigDecimal(number.doubleValue());
    }
}

