/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ClassInfo;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MemberInfo;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataErrorHandler;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.NameSpaceFactory;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.metadata.validators.SimpleValueValidator;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MetaDataHandler
extends XMLParserHandler {
    MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
    private static final String ROOT_TAG = "ReportMetaData";
    private static final String STYLE_TAG = "Style";
    private static final String ELEMENT_TAG = "Element";
    private static final String PROPERTY_TAG = "Property";
    private static final String STYLE_PROPERTY_TAG = "StyleProperty";
    private static final String SLOT_TAG = "Slot";
    private static final String TYPE_TAG = "Type";
    private static final String DEFAULT_TAG = "Default";
    private static final String CHOICE_TAG = "Choice";
    private static final String PROPERTY_GROUP_TAG = "PropertyGroup";
    private static final String CHOICE_TYPE_TAG = "ChoiceType";
    private static final String STRUCTURE_TAG = "Structure";
    private static final String ALLOWED_TAG = "Allowed";
    private static final String ALLOWED_UNITS_TAG = "AllowedUnits";
    private static final String MEMBER_TAG = "Member";
    private static final String VALUE_VALIDATOR_TAG = "ValueValidator";
    private static final String VALIDATORS_TAG = "Validators";
    private static final String METHOD_TAG = "Method";
    private static final String ARGUMENT_TAG = "Argument";
    private static final String CLASS_TAG = "Class";
    private static final String CONSTRUCTOR_TAG = "Constructor";
    private static final String SEMANTIC_VALIDATOR_TAG = "SemanticValidator";
    private static final String TRIGGER_TAG = "Trigger";
    private static final String DEFAULT_UNIT_TAG = "DefaultUnit";
    private static final String PROPERTY_VISIBILITY_TAG = "PropertyVisibility";
    private static final String NAME_ATTRIB = "name";
    private static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
    private static final String EXTENDS_ATTRIB = "extends";
    private static final String TYPE_ATTRIB = "type";
    private static final String SUB_TYPE_ATTRIB = "subType";
    private static final String HAS_STYLE_ATTRIB = "hasStyle";
    private static final String SELECTOR_ATTRIB = "selector";
    private static final String ALLOWS_USER_PROPERTIES_ATTRIB = "allowsUserProperties";
    private static final String CAN_EXTEND_ATTRIB = "canExtend";
    private static final String MULTIPLE_CARDINALITY_ATTRIB = "multipleCardinality";
    private static final String IS_MANAGED_BY_NAME_SPACE_ATTRIB = "isManagedByNameSpace";
    private static final String CAN_INHERIT_ATTRIBUTE = "canInherit";
    private static final String IS_INTRINSIC_ATTRIB = "isIntrinsic";
    private static final String IS_STYLE_PROPERTY_ATTRIB = "isStyleProperty";
    private static final String IS_LIST_ATTRIB = "isList";
    private static final String NAME_SPACE_ATTRIB = "nameSpace";
    private static final String IS_NAME_REQUIRED_ATTRIB = "isNameRequired";
    private static final String IS_ABSTRACT_ATTRIB = "isAbstract";
    private static final String DETAIL_TYPE_ATTRIB = "detailType";
    private static final String JAVA_CLASS_ATTRIB = "javaClass";
    private static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
    private static final String RETURN_TYPE_ATTRIB = "returnType";
    private static final String TAG_ID_ATTRIB = "tagID";
    private static final String DATA_TYPE_ATTRIB = "dataType";
    private static final String IS_STATIC_ATTRIB = "isStatic";
    private static final String VALIDATOR_ATTRIB = "validator";
    private static final String CLASS_ATTRIB = "class";
    private static final String NATIVE_ATTRIB = "native";
    private static final String PRE_REQUISITE_ATTRIB = "preRequisite";
    private static final String TARGET_ELEMENT_ATTRIB = "targetElement";
    private static final String VALUE_REQUIRED_ATTRIB = "valueRequired";
    private static final String PROPERTY_VISIBILITY_ATTRIB = "visibility";
    private static final String SINCE_ATTRIB = "since";
    private static final String XML_NAME_ATTRIB = "xmlName";
    private static final String RUNTIME_SETTABLE_ATTRIB = "runtimeSettable";
    private static final String CONTEXT_ATTRIB = "context";
    private static final String MODULES_ATTRIB = "modules";
    private static final String IS_BIDI_PROPERTY_ATTRIB = "isBidiProperty";
    private static final String THIS_KEYWORD = "this";
    private String groupNameID;
    protected ElementDefn elementDefn = null;
    protected SlotDefn slotDefn = null;
    protected SystemPropertyDefn propDefn = null;
    protected StructureDefn struct = null;
    protected ArrayList choices = new ArrayList();

    MetaDataHandler() {
        super(new MetaDataErrorHandler());
    }

    public AbstractParseState createStartState() {
        return new StartState();
    }

    public void endDocument() throws SAXException {
        if (!this.errorHandler.getErrors().isEmpty()) {
            throw new MetaDataParserException(this.errorHandler.getErrors());
        }
        try {
            this.dictionary.build();
        }
        catch (MetaDataException e) {
            this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            throw new MetaDataParserException(this.errorHandler.getErrors());
        }
        super.endDocument();
    }

    private Choice[] getChoiceArray() {
        Choice[] choiceArray = new Choice[this.choices.size()];
        int i = 0;
        while (i < this.choices.size()) {
            choiceArray[i] = (Choice)this.choices.get(i);
            ++i;
        }
        return choiceArray;
    }

    private ChoiceSet validateChoiceSet(String choiceSetName) {
        IChoiceSet choiceSet = this.dictionary.getChoiceSet(choiceSetName);
        if (choiceSet == null) {
            this.errorHandler.semanticError(new MetaDataParserException("INVALID_CHOICE_TYPE"));
            return null;
        }
        return (ChoiceSet)choiceSet;
    }

    abstract class AbstractMethodState
    extends XMLParserHandler.InnerParseState {
        protected Object owner;
        protected MethodInfo methodInfo;
        private ArgumentInfoList argumentList;

        AbstractMethodState(Object obj) {
            super(MetaDataHandler.this);
            this.owner = null;
            this.methodInfo = null;
            this.argumentList = null;
            assert (obj != null);
            this.owner = obj;
        }

        abstract void addDefnTo();

        abstract MethodInfo getMethodInfo(String var1);

        public void parseAttrs(Attributes attrs) {
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String toolTipID = attrs.getValue(MetaDataHandler.TOOL_TIP_ID_ATTRIB);
            String returnType = attrs.getValue(MetaDataHandler.RETURN_TYPE_ATTRIB);
            boolean isStatic = this.getBooleanAttrib(attrs, MetaDataHandler.IS_STATIC_ATTRIB, false);
            boolean ok = true;
            if (name == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (displayNameID == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            this.methodInfo = this.getMethodInfo(name);
            this.methodInfo.setName(name);
            this.methodInfo.setDisplayNameKey(displayNameID);
            this.methodInfo.setReturnType(returnType);
            this.methodInfo.setToolTipKey(toolTipID);
            this.methodInfo.setStatic(isStatic);
            this.addDefnTo();
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.ARGUMENT_TAG)) {
                return new ArgumentState();
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            if (this.argumentList == null) {
                this.argumentList = new ArgumentInfoList();
            }
            this.methodInfo.addArgumentList(this.argumentList);
            this.methodInfo = null;
            MetaDataHandler.this.propDefn = null;
        }

        class ArgumentState
        extends XMLParserHandler.InnerParseState {
            ArgumentState() {
                super(MetaDataHandler.this);
            }

            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
                String tagID = attrs.getValue(MetaDataHandler.TAG_ID_ATTRIB);
                String type = attrs.getValue(MetaDataHandler.TYPE_ATTRIB);
                if (name == null) {
                    return;
                }
                ArgumentInfo argument = new ArgumentInfo();
                argument.setName(name);
                argument.setType(type);
                argument.setDisplayNameKey(tagID);
                if (AbstractMethodState.this.argumentList == null) {
                    AbstractMethodState.this.argumentList = new ArgumentInfoList();
                }
                try {
                    AbstractMethodState.this.argumentList.addArgument(argument);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class AllowedState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn tmpPropDefn;

        AllowedState(PropertyDefn tmpPropDefn) {
            super(MetaDataHandler.this);
            this.tmpPropDefn = tmpPropDefn;
        }

        public void end() throws SAXException {
            if (this.tmpPropDefn == null) {
                return;
            }
            int type = this.tmpPropDefn.getTypeCode();
            if (type != 3 && type != 5) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("RESTRICTION_NOT_ALLOWED"));
                return;
            }
            ChoiceSet allowedChoices = new ChoiceSet();
            ArrayList<IChoice> allowedList = new ArrayList<IChoice>();
            String choicesStr = StringUtil.trimString(this.text.toString());
            if (choicesStr == null) {
                return;
            }
            String[] nameArray = choicesStr.split(",");
            if (type == 3) {
                IChoiceSet units = MetaDataHandler.this.dictionary.getChoiceSet("units");
                assert (units != null);
                int i = 0;
                while (i < nameArray.length) {
                    IChoice unit = units.findChoice(nameArray[i].trim());
                    if (unit == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                        return;
                    }
                    allowedList.add(unit);
                    ++i;
                }
            } else {
                IChoiceSet choices = this.tmpPropDefn.getChoices();
                assert (choices != null);
                int i = 0;
                while (i < nameArray.length) {
                    IChoice choice = choices.findChoice(nameArray[i].trim());
                    if (choice == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                        return;
                    }
                    allowedList.add(choice);
                    ++i;
                }
            }
            allowedChoices.setChoices(allowedList.toArray(new Choice[0]));
            this.tmpPropDefn.setAllowedChoices(allowedChoices);
        }
    }

    private class AllowedUnitsState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn tmpPropDefn;

        AllowedUnitsState(PropertyDefn tmpPropDefn) {
            super(MetaDataHandler.this);
            this.tmpPropDefn = tmpPropDefn;
        }

        public void end() throws SAXException {
            if (this.tmpPropDefn == null) {
                return;
            }
            int type = this.tmpPropDefn.getTypeCode();
            if (type != 3 && (type != 20 || this.tmpPropDefn.getSubTypeCode() != 3)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("RESTRICTION_NOT_ALLOWED"));
                return;
            }
            ChoiceSet allowedChoices = new ChoiceSet();
            ArrayList<IChoice> allowedList = new ArrayList<IChoice>();
            String choicesStr = StringUtil.trimString(this.text.toString());
            if (choicesStr == null) {
                return;
            }
            String[] nameArray = choicesStr.split(",");
            IChoiceSet units = MetaDataHandler.this.dictionary.getChoiceSet("units");
            assert (units != null);
            int i = 0;
            while (i < nameArray.length) {
                IChoice unit = units.findChoice(nameArray[i].trim());
                if (unit == null) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                    return;
                }
                allowedList.add(unit);
                ++i;
            }
            allowedChoices.setChoices(allowedList.toArray(new Choice[0]));
            this.tmpPropDefn.setAllowedUnits(allowedChoices);
        }
    }

    class ChoiceState
    extends XMLParserHandler.InnerParseState {
        ChoiceState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String xmlName = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else if (StringUtil.isBlank(xmlName)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("XML_NAME_REQUIRED"));
            } else {
                Choice choice = new Choice(xmlName, displayNameID);
                boolean found = false;
                for (Choice tmpChoice : MetaDataHandler.this.choices) {
                    if (!tmpChoice.getName().equalsIgnoreCase(choice.getName())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DUPLICATE_CHOICE_NAME"));
                } else {
                    MetaDataHandler.this.choices.add(choice);
                }
            }
        }
    }

    class ChoiceTypeState
    extends XMLParserHandler.InnerParseState {
        ChoiceSet choiceSet;

        ChoiceTypeState() {
            super(MetaDataHandler.this);
            this.choiceSet = null;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            MetaDataHandler.this.choices.clear();
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            } else {
                this.choiceSet = new ChoiceSet(name);
                try {
                    MetaDataHandler.this.dictionary.addChoiceSet(this.choiceSet);
                }
                catch (MetaDataException e) {
                    this.choiceSet = null;
                    MetaDataHandler.this.errorHandler.semanticError((Exception)((Object)e));
                }
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.CHOICE_TAG)) {
                return new ChoiceState();
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            if (!MetaDataHandler.this.choices.isEmpty() && this.choiceSet != null) {
                this.choiceSet.setChoices(MetaDataHandler.this.getChoiceArray());
            }
        }
    }

    class ClassMethodState
    extends AbstractMethodState {
        private boolean isConstructor;

        ClassMethodState(Object obj, boolean isConstructor) {
            super(obj);
            this.isConstructor = false;
            this.isConstructor = isConstructor;
        }

        MethodInfo getMethodInfo(String name) {
            ClassInfo classInfo = (ClassInfo)this.owner;
            if (classInfo != null) {
                this.methodInfo = this.isConstructor ? (MethodInfo)classInfo.getConstructor() : classInfo.findMethod(name);
            }
            if (this.methodInfo == null) {
                this.methodInfo = new MethodInfo(this.isConstructor);
            }
            return this.methodInfo;
        }

        void addDefnTo() {
            assert (this.owner instanceof ClassInfo);
            ClassInfo classInfo = (ClassInfo)this.owner;
            try {
                if (this.isConstructor) {
                    if (classInfo.getConstructor() == null) {
                        classInfo.setConstructor(this.methodInfo);
                    }
                } else if (classInfo.findMethod(this.methodInfo.getName()) == null) {
                    classInfo.addMethod(this.methodInfo);
                }
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }
    }

    class ClassState
    extends XMLParserHandler.InnerParseState {
        ClassInfo classInfo;

        ClassState() {
            super(MetaDataHandler.this);
            this.classInfo = null;
        }

        public void parseAttrs(Attributes attrs) {
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String toolTipID = attrs.getValue(MetaDataHandler.TOOL_TIP_ID_ATTRIB);
            String isNative = attrs.getValue(MetaDataHandler.NATIVE_ATTRIB);
            boolean ok = true;
            if (name == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (displayNameID == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            this.classInfo = new ClassInfo();
            this.classInfo.setName(name);
            this.classInfo.setDisplayNameKey(displayNameID);
            this.classInfo.setToolTipKey(toolTipID);
            if (Boolean.TRUE.toString().equalsIgnoreCase(isNative)) {
                this.classInfo.setNative(true);
            } else if (Boolean.FALSE.toString().equalsIgnoreCase(isNative)) {
                this.classInfo.setNative(false);
            }
            try {
                MetaDataHandler.this.dictionary.addClass(this.classInfo);
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.CONSTRUCTOR_TAG)) {
                return new ClassMethodState(this.classInfo, true);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.MEMBER_TAG)) {
                return new MemberState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.METHOD_TAG)) {
                return new ClassMethodState(this.classInfo, false);
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            super.end();
            this.classInfo = null;
        }

        private class MemberState
        extends XMLParserHandler.InnerParseState {
            private MemberState() {
                super(MetaDataHandler.this);
            }

            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
                String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
                String toolTipID = attrs.getValue(MetaDataHandler.TOOL_TIP_ID_ATTRIB);
                String dataType = attrs.getValue(MetaDataHandler.DATA_TYPE_ATTRIB);
                boolean ok = true;
                if (name == null) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                    ok = false;
                }
                if (displayNameID == null) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                    ok = false;
                }
                if (dataType == null) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DATA_TYPE_REQUIRED"));
                    ok = false;
                }
                if (!ok) {
                    return;
                }
                MemberInfo memberDefn = new MemberInfo();
                memberDefn.setName(name);
                memberDefn.setDisplayNameKey(displayNameID);
                memberDefn.setToolTipKey(toolTipID);
                memberDefn.setDataType(dataType);
                memberDefn.setStatic(this.getBooleanAttrib(attrs, MetaDataHandler.IS_STATIC_ATTRIB, false));
                try {
                    ClassState.this.classInfo.addMemberDefn(memberDefn);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class DefaultUnitState
    extends XMLParserHandler.InnerParseState {
        DefaultUnitState() {
            super(MetaDataHandler.this);
        }

        public void end() throws SAXException {
            if (MetaDataHandler.this.propDefn == null) {
                return;
            }
            int type = MetaDataHandler.this.propDefn.getTypeCode();
            if (type != 3) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DEFAULT_UNIT_NOT_ALLOWED"));
                return;
            }
            MetaDataHandler.this.propDefn.setDefaultUnit(this.text.toString());
        }
    }

    class DefaultValueState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn propertyDefn;

        DefaultValueState(PropertyDefn propDefn) {
            super(MetaDataHandler.this);
            this.propertyDefn = null;
            this.propertyDefn = propDefn;
        }

        public void end() throws SAXException {
            if (this.propertyDefn == null) {
                return;
            }
            try {
                Object value = this.propertyDefn.validateXml(null, this.text.toString());
                this.propertyDefn.setDefault(value);
            }
            catch (PropertyValueException propertyValueException) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_DEFAULT"));
            }
        }
    }

    class ElementDefnState
    extends XMLParserHandler.InnerParseState {
        ElementDefnState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) {
            String ns;
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            boolean ok = true;
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            MetaDataHandler.this.elementDefn = new ElementDefn();
            MetaDataHandler.this.elementDefn.setName(name);
            MetaDataHandler.this.elementDefn.setAbstract(this.getBooleanAttrib(attrs, MetaDataHandler.IS_ABSTRACT_ATTRIB, false));
            MetaDataHandler.this.elementDefn.setDisplayNameKey(displayNameID);
            MetaDataHandler.this.elementDefn.setExtends(attrs.getValue(MetaDataHandler.EXTENDS_ATTRIB));
            MetaDataHandler.this.elementDefn.setHasStyle(this.getBooleanAttrib(attrs, MetaDataHandler.HAS_STYLE_ATTRIB, false));
            MetaDataHandler.this.elementDefn.setSelector(attrs.getValue(MetaDataHandler.SELECTOR_ATTRIB));
            MetaDataHandler.this.elementDefn.setAllowsUserProperties(this.getBooleanAttrib(attrs, MetaDataHandler.ALLOWS_USER_PROPERTIES_ATTRIB, true));
            MetaDataHandler.this.elementDefn.setJavaClass(attrs.getValue(MetaDataHandler.JAVA_CLASS_ATTRIB));
            MetaDataHandler.this.elementDefn.setCanExtend(this.getBooleanAttrib(attrs, MetaDataHandler.CAN_EXTEND_ATTRIB, true));
            MetaDataHandler.this.elementDefn.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
            MetaDataHandler.this.elementDefn.setXmlName(attrs.getValue(MetaDataHandler.XML_NAME_ATTRIB));
            String nameRequired = attrs.getValue(MetaDataHandler.IS_NAME_REQUIRED_ATTRIB);
            if (nameRequired != null) {
                boolean flag = this.parseBoolean(nameRequired, false);
                MetaDataHandler.this.elementDefn.setNameOption(flag ? 2 : 1);
            }
            if ((ns = attrs.getValue(MetaDataHandler.NAME_SPACE_ATTRIB)) != null && ns.trim().length() != 0) {
                if (ns.equalsIgnoreCase("style")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(0);
                } else if (ns.equalsIgnoreCase("theme")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(6);
                } else if (ns.equalsIgnoreCase("dataSet")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(4);
                } else if (ns.equalsIgnoreCase("dataSource")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(3);
                } else if (ns.equalsIgnoreCase("element")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(1);
                } else if (ns.equalsIgnoreCase("parameter")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(2);
                } else if (ns.equalsIgnoreCase("masterPage")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(5);
                } else if (ns.equalsIgnoreCase("none")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(-1);
                } else if (ns.equalsIgnoreCase("templateParameterDefinition")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(7);
                } else if (ns.equalsIgnoreCase("cube")) {
                    MetaDataHandler.this.elementDefn.setNameSpaceID(8);
                } else if (ns.startsWith("(") && ns.endsWith(")")) {
                    String nsValue = ns.substring(1, ns.length() - 1);
                    int index = nsValue.indexOf(",");
                    if (index == -1) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_NAME_SPACE"));
                    } else {
                        String holderName = StringUtil.trimString(nsValue.substring(0, index));
                        String nameSpace = StringUtil.trimString(nsValue.substring(index + 1, nsValue.length()));
                        MetaDataHandler.this.elementDefn.nameConfig.holderName = holderName;
                        MetaDataHandler.this.elementDefn.nameConfig.nameSpaceID = NameSpaceFactory.getNameSpaceID(holderName, nameSpace);
                    }
                } else {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_NAME_SPACE"));
                }
            }
            try {
                MetaDataHandler.this.dictionary.addElementDefn(MetaDataHandler.this.elementDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.PROPERTY_TAG)) {
                return new PropertyState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.PROPERTY_GROUP_TAG)) {
                return new PropertyGroupState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.STYLE_PROPERTY_TAG)) {
                return new StylePropertyState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.SLOT_TAG)) {
                return new SlotState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.METHOD_TAG)) {
                return new ElementMethodState(MetaDataHandler.this.elementDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.SEMANTIC_VALIDATOR_TAG)) {
                return new TriggerState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.PROPERTY_VISIBILITY_TAG)) {
                return new PropertyVisibilityState();
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            super.end();
            MetaDataHandler.this.elementDefn = null;
        }

        private class PropertyVisibilityState
        extends XMLParserHandler.InnerParseState {
            private PropertyVisibilityState() {
                super(MetaDataHandler.this);
            }

            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
                String visible = attrs.getValue(MetaDataHandler.PROPERTY_VISIBILITY_ATTRIB);
                if (StringUtil.isBlank(name)) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                    return;
                }
                ((ElementDefnState)ElementDefnState.this).MetaDataHandler.this.elementDefn.addPropertyVisibility(name, visible);
            }
        }
    }

    class ElementMethodState
    extends AbstractMethodState {
        SystemPropertyDefn localPropDefn;

        MethodInfo getMethodInfo(String name) {
            return new MethodInfo(false);
        }

        ElementMethodState(Object obj) {
            super(obj);
            this.localPropDefn = new SystemPropertyDefn();
        }

        public void parseAttrs(Attributes attrs) {
            super.parseAttrs(attrs);
            this.localPropDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandler.VALUE_REQUIRED_ATTRIB, false));
            this.localPropDefn.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
            this.localPropDefn.setContext(attrs.getValue(MetaDataHandler.CONTEXT_ATTRIB));
            this.localPropDefn.setReturnType(attrs.getValue(MetaDataHandler.RETURN_TYPE_ATTRIB));
        }

        void addDefnTo() {
            assert (this.owner instanceof ElementDefn);
            PropertyType typeDefn = MetaDataHandler.this.dictionary.getPropertyType(18);
            String name = this.methodInfo.getName();
            String displayNameID = this.methodInfo.getDisplayNameKey();
            this.localPropDefn.setName(name);
            this.localPropDefn.setDisplayNameID(displayNameID);
            this.localPropDefn.setType(typeDefn);
            this.localPropDefn.setGroupNameKey(null);
            this.localPropDefn.setCanInherit(true);
            this.localPropDefn.setIntrinsic(false);
            this.localPropDefn.setStyleProperty(false);
            this.localPropDefn.setDetails(this.methodInfo);
            try {
                ((ElementDefn)this.owner).addProperty(this.localPropDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }
    }

    class MemberState
    extends XMLParserHandler.InnerParseState {
        StructPropertyDefn memberDefn;

        MemberState() {
            super(MetaDataHandler.this);
            this.memberDefn = null;
        }

        public void parseAttrs(Attributes attrs) {
            boolean ok;
            String name = this.getAttrib(attrs, MetaDataHandler.NAME_ATTRIB);
            String displayNameID = this.getAttrib(attrs, MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String type = this.getAttrib(attrs, MetaDataHandler.TYPE_ATTRIB);
            String validator = this.getAttrib(attrs, MetaDataHandler.VALIDATOR_ATTRIB);
            String subType = this.getAttrib(attrs, MetaDataHandler.SUB_TYPE_ATTRIB);
            boolean bl = ok = MetaDataHandler.this.struct != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (StringUtil.isBlank(type)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("TYPE_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            PropertyType typeDefn = MetaDataHandler.this.dictionary.getPropertyType(type);
            if (typeDefn == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                return;
            }
            if (!ok) {
                return;
            }
            String detailName = this.getAttrib(attrs, MetaDataHandler.DETAIL_TYPE_ATTRIB);
            ChoiceSet choiceSet = null;
            String structDefn = null;
            PropertyType subTypeDefn = null;
            switch (typeDefn.getTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 11: 
                case 14: 
                case 21: {
                    if (detailName == null || (choiceSet = MetaDataHandler.this.validateChoiceSet(detailName)) != null) break;
                    return;
                }
                case 5: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("CHOICE_TYPE_REQUIRED"));
                        return;
                    }
                    choiceSet = MetaDataHandler.this.validateChoiceSet(detailName);
                    if (choiceSet != null) break;
                    return;
                }
                case 4: {
                    choiceSet = MetaDataHandler.this.validateChoiceSet("colors");
                    if (choiceSet != null) break;
                    return;
                }
                case 16: 
                case 19: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("STRUCT_TYPE_REQUIRED"));
                        return;
                    }
                    structDefn = detailName;
                    break;
                }
                case 15: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandler.THIS_KEYWORD)) break;
                    detailName = MetaDataHandler.this.elementDefn.getName();
                    break;
                }
                case 20: {
                    if (subType == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("MISSING_SUB_TYPE"));
                        break;
                    }
                    subTypeDefn = MetaDataHandler.this.dictionary.getPropertyType(subType);
                    if (subTypeDefn == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                        return;
                    }
                    if (subTypeDefn.getTypeCode() != 15) break;
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandler.THIS_KEYWORD)) break;
                    detailName = MetaDataHandler.this.elementDefn.getName();
                }
            }
            this.memberDefn = new StructPropertyDefn();
            this.memberDefn.setName(name);
            this.memberDefn.setType(typeDefn);
            if (subTypeDefn != null && typeDefn.getTypeCode() == 20) {
                this.memberDefn.setSubType(subTypeDefn);
            }
            this.memberDefn.setDisplayNameID(displayNameID);
            this.memberDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandler.VALUE_REQUIRED_ATTRIB, false));
            this.memberDefn.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
            this.memberDefn.setRuntimeSettable(this.getBooleanAttrib(attrs, MetaDataHandler.RUNTIME_SETTABLE_ATTRIB, true));
            if (this.memberDefn.getTypeCode() == 7) {
                this.memberDefn.setReturnType(attrs.getValue(MetaDataHandler.RETURN_TYPE_ATTRIB));
                this.memberDefn.setContext(attrs.getValue(MetaDataHandler.CONTEXT_ATTRIB));
            }
            if (!StringUtil.isBlank(validator)) {
                this.memberDefn.setValueValidator(validator);
            }
            if (typeDefn.getTypeCode() == 16) {
                this.memberDefn.setIsList(this.getBooleanAttrib(attrs, MetaDataHandler.IS_LIST_ATTRIB, false));
            }
            if (choiceSet != null) {
                this.memberDefn.setDetails(choiceSet);
            } else if (structDefn != null) {
                this.memberDefn.setDetails(structDefn);
            } else if (detailName != null) {
                this.memberDefn.setDetails(detailName);
            }
            this.memberDefn.setIntrinsic(this.getBooleanAttrib(attrs, MetaDataHandler.IS_INTRINSIC_ATTRIB, false));
            try {
                MetaDataHandler.this.struct.addProperty(this.memberDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError((Exception)((Object)e));
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.DEFAULT_TAG)) {
                return new DefaultValueState(this.memberDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.ALLOWED_TAG)) {
                return new AllowedState(this.memberDefn);
            }
            return super.startElement(tagName);
        }
    }

    class PropertyGroupState
    extends XMLParserHandler.InnerParseState {
        PropertyGroupState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) {
            MetaDataHandler.this.groupNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            if (StringUtil.isBlank(MetaDataHandler.this.groupNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("GROUP_NAME_ID_REQUIRED"));
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.PROPERTY_TAG)) {
                return new PropertyState();
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            MetaDataHandler.this.groupNameID = null;
        }
    }

    class PropertyState
    extends XMLParserHandler.InnerParseState {
        List propertyTypes;

        PropertyState() {
            super(MetaDataHandler.this);
            this.propertyTypes = new ArrayList();
        }

        public void parseAttrs(Attributes attrs) {
            int typeCode;
            boolean ok;
            MetaDataHandler.this.choices.clear();
            MetaDataHandler.this.propDefn = null;
            String name = this.getAttrib(attrs, MetaDataHandler.NAME_ATTRIB);
            String displayNameID = this.getAttrib(attrs, MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String type = this.getAttrib(attrs, MetaDataHandler.TYPE_ATTRIB);
            String validator = this.getAttrib(attrs, MetaDataHandler.VALIDATOR_ATTRIB);
            String subType = this.getAttrib(attrs, MetaDataHandler.SUB_TYPE_ATTRIB);
            boolean bl = ok = MetaDataHandler.this.elementDefn != null;
            if (name == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (displayNameID == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (type == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("TYPE_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            PropertyType typeDefn = MetaDataHandler.this.dictionary.getPropertyType(type);
            if (typeDefn == null) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                return;
            }
            String detailName = this.getAttrib(attrs, MetaDataHandler.DETAIL_TYPE_ATTRIB);
            ChoiceSet choiceSet = null;
            StructureDefn struct = null;
            PropertyType subTypeDefn = null;
            switch (typeDefn.getTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 11: 
                case 14: 
                case 21: {
                    if (detailName == null || (choiceSet = MetaDataHandler.this.validateChoiceSet(detailName)) != null) break;
                    return;
                }
                case 5: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("CHOICE_TYPE_REQUIRED"));
                        return;
                    }
                    choiceSet = MetaDataHandler.this.validateChoiceSet(detailName);
                    if (choiceSet != null) break;
                    return;
                }
                case 4: {
                    choiceSet = MetaDataHandler.this.validateChoiceSet("colors");
                    if (choiceSet != null) break;
                    return;
                }
                case 16: 
                case 19: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("STRUCT_TYPE_REQUIRED"));
                        return;
                    }
                    struct = (StructureDefn)MetaDataHandler.this.dictionary.getStructure(detailName);
                    if (struct != null) break;
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_STRUCT_TYPE"));
                    return;
                }
                case 15: {
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandler.THIS_KEYWORD)) break;
                    detailName = MetaDataHandler.this.elementDefn.getName();
                    break;
                }
                case 20: {
                    if (subType == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("MISSING_SUB_TYPE"));
                        break;
                    }
                    subTypeDefn = MetaDataHandler.this.dictionary.getPropertyType(subType);
                    if (subTypeDefn == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                        return;
                    }
                    if (subTypeDefn.getTypeCode() != 15) break;
                    if (detailName == null) {
                        MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandler.THIS_KEYWORD)) break;
                    detailName = MetaDataHandler.this.elementDefn.getName();
                    break;
                }
                default: {
                    detailName = null;
                }
            }
            MetaDataHandler.this.propDefn = new SystemPropertyDefn();
            MetaDataHandler.this.propDefn.setName(name);
            MetaDataHandler.this.propDefn.setDisplayNameID(displayNameID);
            MetaDataHandler.this.propDefn.setType(typeDefn);
            if (typeDefn.getTypeCode() == 20) {
                MetaDataHandler.this.propDefn.setSubType(subTypeDefn);
            }
            MetaDataHandler.this.propDefn.setGroupNameKey(MetaDataHandler.this.groupNameID);
            MetaDataHandler.this.propDefn.setCanInherit(this.getBooleanAttrib(attrs, MetaDataHandler.CAN_INHERIT_ATTRIBUTE, true));
            MetaDataHandler.this.propDefn.setIntrinsic(this.getBooleanAttrib(attrs, MetaDataHandler.IS_INTRINSIC_ATTRIB, false));
            MetaDataHandler.this.propDefn.setStyleProperty(this.getBooleanAttrib(attrs, MetaDataHandler.IS_STYLE_PROPERTY_ATTRIB, false));
            MetaDataHandler.this.propDefn.setBidiProperty(this.getBooleanAttrib(attrs, MetaDataHandler.IS_BIDI_PROPERTY_ATTRIB, false));
            MetaDataHandler.this.propDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandler.VALUE_REQUIRED_ATTRIB, false));
            MetaDataHandler.this.propDefn.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
            MetaDataHandler.this.propDefn.setRuntimeSettable(this.getBooleanAttrib(attrs, MetaDataHandler.RUNTIME_SETTABLE_ATTRIB, true));
            if (MetaDataHandler.this.propDefn.getTypeCode() == 7) {
                MetaDataHandler.this.propDefn.setReturnType(attrs.getValue(MetaDataHandler.RETURN_TYPE_ATTRIB));
                MetaDataHandler.this.propDefn.setContext(attrs.getValue(MetaDataHandler.CONTEXT_ATTRIB));
            }
            if (!StringUtil.isBlank(validator)) {
                MetaDataHandler.this.propDefn.setValueValidator(validator);
            }
            if ((typeCode = typeDefn.getTypeCode()) == 16 || MetaDataHandler.this.propDefn.isElementType()) {
                MetaDataHandler.this.propDefn.setIsList(this.getBooleanAttrib(attrs, MetaDataHandler.IS_LIST_ATTRIB, false));
            }
            if (choiceSet != null) {
                MetaDataHandler.this.propDefn.setDetails(choiceSet);
            } else if (struct != null) {
                MetaDataHandler.this.propDefn.setDetails(struct);
            } else if (detailName != null) {
                MetaDataHandler.this.propDefn.setDetails(detailName);
            }
            try {
                MetaDataHandler.this.elementDefn.addProperty(MetaDataHandler.this.propDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.DEFAULT_TAG)) {
                return new DefaultValueState(MetaDataHandler.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.ALLOWED_TAG)) {
                return new AllowedState(MetaDataHandler.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.ALLOWED_UNITS_TAG)) {
                return new AllowedUnitsState(MetaDataHandler.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.TRIGGER_TAG)) {
                return new TriggerState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.DEFAULT_UNIT_TAG)) {
                return new DefaultUnitState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.TYPE_TAG)) {
                return new PropertyTypeState(this.propertyTypes);
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            if (MetaDataHandler.this.propDefn != null && MetaDataHandler.this.propDefn.isElementType()) {
                MetaDataHandler.this.propDefn.setDetails(this.propertyTypes);
            }
            MetaDataHandler.this.propDefn = null;
        }
    }

    class PropertyTypeState
    extends XMLParserHandler.InnerParseState {
        protected List types;

        public PropertyTypeState(List propertyTypes) {
            super(MetaDataHandler.this);
            this.types = null;
            this.types = propertyTypes;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok = MetaDataHandler.this.propDefn != null;
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                this.types.add(name);
            }
        }
    }

    class RootState
    extends XMLParserHandler.InnerParseState {
        RootState() {
            super(MetaDataHandler.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (MetaDataHandler.CHOICE_TYPE_TAG.equalsIgnoreCase(tagName)) {
                return new ChoiceTypeState();
            }
            if (MetaDataHandler.STRUCTURE_TAG.equalsIgnoreCase(tagName)) {
                return new StructDefnState();
            }
            if (MetaDataHandler.ELEMENT_TAG.equalsIgnoreCase(tagName)) {
                return new ElementDefnState();
            }
            if (MetaDataHandler.STYLE_TAG.equalsIgnoreCase(tagName)) {
                return new StyleState();
            }
            if (MetaDataHandler.CLASS_TAG.equalsIgnoreCase(tagName)) {
                return new ClassState();
            }
            if (MetaDataHandler.VALIDATORS_TAG.equalsIgnoreCase(tagName)) {
                return new ValidatorsState();
            }
            return super.startElement(tagName);
        }
    }

    class SemanticValidatorState
    extends XMLParserHandler.InnerParseState {
        SemanticValidatorState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = this.getAttrib(attrs, MetaDataHandler.NAME_ATTRIB);
            String modules = this.getAttrib(attrs, MetaDataHandler.MODULES_ATTRIB);
            String className = this.getAttrib(attrs, MetaDataHandler.CLASS_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
                return;
            }
            if (StringUtil.isBlank(className)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("CLASS_NAME_REQUIRED"));
                return;
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod("getInstance", null);
                AbstractSemanticValidator validator = (AbstractSemanticValidator)m.invoke(null, null);
                validator.setName(name);
                validator.setModules(modules);
                try {
                    MetaDataHandler.this.dictionary.addSemanticValidator(validator);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
            catch (Exception exception) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_META_VALIDATOR"));
            }
        }
    }

    class SlotState
    extends XMLParserHandler.InnerParseState {
        SlotState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok;
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            String multipleCardinality = attrs.getValue(MetaDataHandler.MULTIPLE_CARDINALITY_ATTRIB);
            boolean bl = ok = MetaDataHandler.this.elementDefn != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            } else if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            } else if (StringUtil.isBlank(multipleCardinality)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("MULTIPLE_CARDINALITY_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            MetaDataHandler.this.slotDefn = new SlotDefn();
            MetaDataHandler.this.slotDefn.setName(name);
            MetaDataHandler.this.slotDefn.setDisplayNameID(displayNameID);
            MetaDataHandler.this.slotDefn.setManagedByNameSpace(this.getBooleanAttrib(attrs, MetaDataHandler.IS_MANAGED_BY_NAME_SPACE_ATTRIB, true));
            MetaDataHandler.this.slotDefn.setMultipleCardinality(this.parseBoolean(multipleCardinality, true));
            MetaDataHandler.this.slotDefn.setSelector(attrs.getValue(MetaDataHandler.SELECTOR_ATTRIB));
            MetaDataHandler.this.slotDefn.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
            MetaDataHandler.this.slotDefn.setXmlName(attrs.getValue(MetaDataHandler.XML_NAME_ATTRIB));
            MetaDataHandler.this.elementDefn.addSlot(MetaDataHandler.this.slotDefn);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.TYPE_TAG)) {
                return new SlotTypeState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandler.TRIGGER_TAG)) {
                return new TriggerState();
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            super.end();
            MetaDataHandler.this.slotDefn = null;
        }
    }

    class SlotTypeState
    extends XMLParserHandler.InnerParseState {
        SlotTypeState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok = MetaDataHandler.this.slotDefn != null;
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                MetaDataHandler.this.slotDefn.addType(name);
            }
        }
    }

    class StartState
    extends XMLParserHandler.InnerParseState {
        StartState() {
            super(MetaDataHandler.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.ROOT_TAG)) {
                return new RootState();
            }
            return super.startElement(tagName);
        }
    }

    class StructDefnState
    extends XMLParserHandler.InnerParseState {
        StructDefnState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            }
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else {
                MetaDataHandler.this.struct = new StructureDefn(name);
                MetaDataHandler.this.struct.setDisplayNameKey(attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB));
                MetaDataHandler.this.struct.setSince(attrs.getValue(MetaDataHandler.SINCE_ATTRIB));
                try {
                    MetaDataHandler.this.dictionary.addStructure(MetaDataHandler.this.struct);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }

        public void end() throws SAXException {
            super.end();
            MetaDataHandler.this.struct = null;
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandler.MEMBER_TAG)) {
                return new MemberState();
            }
            return super.startElement(tagName);
        }
    }

    class StylePropertyState
    extends XMLParserHandler.InnerParseState {
        StylePropertyState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok;
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            boolean bl = ok = MetaDataHandler.this.elementDefn != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                MetaDataHandler.this.elementDefn.addStyleProperty(name);
            }
        }
    }

    class StyleState
    extends XMLParserHandler.InnerParseState {
        StyleState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = attrs.getValue(MetaDataHandler.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandler.DISPLAY_NAME_ID_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            } else if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else {
                PredefinedStyle style = new PredefinedStyle();
                style.setName(name);
                style.setDisplayNameKey(displayNameID);
                try {
                    MetaDataHandler.this.dictionary.addPredefinedStyle(style);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class TriggerState
    extends XMLParserHandler.InnerParseState {
        TriggerState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            assert (MetaDataHandler.this.propDefn != null || MetaDataHandler.this.slotDefn != null);
            String validatorName = attrs.getValue(MetaDataHandler.VALIDATOR_ATTRIB);
            String targetElement = attrs.getValue(MetaDataHandler.TARGET_ELEMENT_ATTRIB);
            if (!StringUtil.isBlank(validatorName)) {
                SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn(validatorName);
                triggerDefn.setPreRequisite(this.getBooleanAttrib(attrs, MetaDataHandler.PRE_REQUISITE_ATTRIB, false));
                if (!StringUtil.isBlank(targetElement)) {
                    triggerDefn.setTargetElement(targetElement);
                }
                if (MetaDataHandler.this.propDefn != null) {
                    MetaDataHandler.this.propDefn.getTriggerDefnSet().add(triggerDefn);
                }
                if (MetaDataHandler.this.slotDefn != null) {
                    MetaDataHandler.this.slotDefn.getTriggerDefnSet().add(triggerDefn);
                }
            } else {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
            }
        }
    }

    class ValidatorsState
    extends XMLParserHandler.InnerParseState {
        ValidatorsState() {
            super(MetaDataHandler.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (MetaDataHandler.VALUE_VALIDATOR_TAG.equalsIgnoreCase(tagName)) {
                return new ValueValidatorState();
            }
            if (MetaDataHandler.SEMANTIC_VALIDATOR_TAG.equalsIgnoreCase(tagName)) {
                return new SemanticValidatorState();
            }
            return super.startElement(tagName);
        }
    }

    class ValueValidatorState
    extends XMLParserHandler.InnerParseState {
        ValueValidatorState() {
            super(MetaDataHandler.this);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = this.getAttrib(attrs, MetaDataHandler.NAME_ATTRIB);
            String className = this.getAttrib(attrs, MetaDataHandler.CLASS_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
                return;
            }
            if (StringUtil.isBlank(className)) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("CLASS_NAME_REQUIRED"));
                return;
            }
            try {
                Class<?> c = Class.forName(className);
                SimpleValueValidator validator = (SimpleValueValidator)c.newInstance();
                validator.setName(name);
                try {
                    MetaDataHandler.this.dictionary.addValueValidator(validator);
                }
                catch (MetaDataException e) {
                    MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
            catch (Exception exception) {
                MetaDataHandler.this.errorHandler.semanticError(new MetaDataParserException("INVALID_META_VALIDATOR"));
            }
        }
    }
}

