/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleNameContext
extends AbstractModuleNameContext {
    StyleNameContext(Module module) {
        super(module, 0);
    }

    @Override
    public List getElements(int level) {
        LinkedHashMap<String, DesignElement> elements = new LinkedHashMap<String, DesignElement>();
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return new ArrayList(elements.values());
        }
        if (theme != null) {
            List allStyles = theme.getAllStyles();
            this.addAllStyles(elements, allStyles);
        }
        if (this.module instanceof Library) {
            return new ArrayList(elements.values());
        }
        List csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
        this.addAllStyles(elements, csses);
        NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
        List styles = ns.getElements();
        this.addAllStyles(elements, styles);
        return new ArrayList(elements.values());
    }

    private void addAllStyles(Map<String, DesignElement> styleMap, List<DesignElement> styleList) {
        assert (styleMap != null);
        if (styleList != null) {
            int i = 0;
            while (i < styleList.size()) {
                DesignElement style = styleList.get(i);
                styleMap.put(style.getName(), style);
                ++i;
            }
        }
    }

    private ElementRefValue resolve(DesignElement element) {
        return new ElementRefValue(null, element);
    }

    private ElementRefValue resolve(String elementName) {
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return new ElementRefValue(null, elementName);
        }
        DesignElement target = null;
        if (this.module instanceof ReportDesign) {
            NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
            target = ns.getElement(elementName);
            if (target != null) {
                return new ElementRefValue(null, target);
            }
            List csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
            int i = 0;
            while (csses != null && i < csses.size()) {
                CssStyle cssStyle = (CssStyle)csses.get(i);
                if (elementName.equalsIgnoreCase(cssStyle.getFullName())) {
                    return new ElementRefValue(null, cssStyle);
                }
                ++i;
            }
        }
        StyleElement libraryStyle = null;
        if (theme != null) {
            libraryStyle = theme.findStyle(elementName);
        }
        if (libraryStyle != null) {
            return new ElementRefValue(null, libraryStyle);
        }
        List<DesignElement> defaultTocStyle = this.module.getSession().getDefaultTOCStyleValue();
        for (Style style : defaultTocStyle) {
            if (!style.getName().equalsIgnoreCase(elementName)) continue;
            return new ElementRefValue(null, style);
        }
        return new ElementRefValue(null, elementName);
    }

    @Override
    public ElementRefValue resolve(DesignElement element, PropertyDefn propDefn) {
        return this.resolve(element);
    }

    @Override
    public ElementRefValue resolve(String elementName, PropertyDefn propDefn) {
        return this.resolve(elementName);
    }

    @Override
    public DesignElement findElement(String elementName, IElementDefn elementDefn) {
        ElementRefValue refValue = this.resolve(elementName);
        return refValue == null ? null : refValue.getElement();
    }
}

