/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class BundleHelper {
    private Module module = null;
    private String baseName = null;

    private BundleHelper(Module module, String baseName) {
        this.module = module;
        this.baseName = baseName;
    }

    public static BundleHelper getHelper(Module module, String baseName) {
        assert (module != null);
        return new BundleHelper(module, baseName);
    }

    public Collection getMessageKeys(ULocale locale) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (PropertyResourceBundle bundle : this.gatherMessageBundles(locale)) {
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                keys.add(enumeration.nextElement());
            }
        }
        return keys;
    }

    public String getMessage(String resourceKey, ULocale locale) {
        Iterator bundleIter = this.gatherMessageBundles(locale).iterator();
        while (bundleIter.hasNext()) {
            String translation = (String)((PropertyResourceBundle)bundleIter.next()).handleGetObject(resourceKey);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    private List gatherMessageBundles(ULocale locale) {
        ArrayList<PropertyResourceBundle> bundleHierarchy = this.module.getCachePropertyResourceBundles(this.baseName);
        if (bundleHierarchy != null) {
            return bundleHierarchy;
        }
        bundleHierarchy = new ArrayList<PropertyResourceBundle>();
        List bundleNames = this.getMessageFilenames(locale);
        URL cachedURL = null;
        String cachedBundleName = null;
        PropertyResourceBundle bundle = null;
        int i = 0;
        while (i < bundleNames.size()) {
            URL ret;
            int beginIndex;
            String url;
            int index;
            boolean isIntegrated = false;
            String bundleName = (String)bundleNames.get(i);
            if (cachedURL != null && cachedBundleName != null && (index = (url = cachedURL.toString()).lastIndexOf(cachedBundleName)) > -1 && (beginIndex = index + cachedBundleName.length()) <= url.length()) {
                isIntegrated = true;
                url = String.valueOf(url.substring(0, index)) + bundleName + url.substring(beginIndex);
                try {
                    bundle = this.populateBundle(new URL(url));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (!isIntegrated && (bundle = this.populateBundle(ret = this.findBundle(bundleName))) != null) {
                cachedBundleName = bundleName;
                cachedURL = ret;
            }
            if (bundle != null) {
                bundleHierarchy.add(bundle);
            }
            ++i;
        }
        this.module.cachePropertyResourceBundles(this.baseName, bundleHierarchy);
        return bundleHierarchy;
    }

    public List getMessageFilenames(ULocale locale) {
        StringBuffer temp;
        if (locale == null) {
            locale = ThreadResources.getLocale();
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        if (this.baseName == null) {
            return bundleNames;
        }
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength > 0 && countryLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append("_");
            temp.append(country);
            StringBuffer variantTmp = new StringBuffer(temp.toString());
            if (variantLength > 0) {
                variantTmp.append("_");
                variantTmp.append(variant);
                variantTmp.append(".properties");
                bundleNames.add(variantTmp.toString());
            }
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        if (languageLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        bundleNames.add(String.valueOf(this.baseName) + ".properties");
        return bundleNames;
    }

    private URL findBundle(String fileName) {
        assert (fileName != null);
        return this.module.getSession().getResourceLocator().findResource(this.module.getModuleHandle(), fileName, 0);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PropertyResourceBundle populateBundle(URL bundleURL) {
        InputStream is;
        block17: {
            is = null;
            if (bundleURL != null) break block17;
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        is = bundleURL.openStream();
        PropertyResourceBundle bundle = new PropertyResourceBundle(is);
        is.close();
        is = null;
        PropertyResourceBundle propertyResourceBundle = bundle;
        if (is == null) return propertyResourceBundle;
        try {
            is.close();
            return propertyResourceBundle;
        }
        catch (IOException iOException) {
            return propertyResourceBundle;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {
                        is = null;
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException3) {
                return null;
            }
        }
    }
}

