/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentReplaceEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class ContentReplaceRecord
extends SimpleRecord {
    protected ContainerContext focus = null;
    protected final DesignElement newElement;
    protected final DesignElement oldElement;
    protected final Module module;
    protected int posn;

    public ContentReplaceRecord(Module module, ContainerContext containerInfo, DesignElement oldElement, DesignElement newElement) {
        this.module = module;
        this.focus = containerInfo;
        this.oldElement = oldElement;
        this.newElement = newElement;
        assert (module != null);
        assert (containerInfo != null);
        this.posn = this.focus.indexOf(module, oldElement);
        assert (this.posn != -1);
        this.label = CommandLabelFactory.getCommandLabel("Message.ReplaceElement");
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.replace(this.newElement, this.oldElement);
        } else {
            this.replace(this.oldElement, this.newElement);
        }
    }

    private void replace(DesignElement oldElement, DesignElement newElement) {
        if (oldElement.getRoot() != null) {
            this.module.manageId(oldElement, false);
        }
        this.focus.remove(this.module, oldElement);
        this.focus.add(this.module, newElement, this.posn);
        if (newElement.getRoot() != null) {
            this.module.manageId(newElement, true);
        }
    }

    public DesignElement getTarget() {
        return this.focus.getElement();
    }

    public NotificationEvent getEvent() {
        return null;
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    public List getValidators() {
        List list = ValidationExecutor.getValidationNodes(this.focus.getElement(), this.focus.getTriggerSetForContainerDefn(), false);
        if (this.state != 2) {
            ElementDefn contentDefn = (ElementDefn)this.newElement.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.newElement, contentDefn.getTriggerDefnSet(), false));
        } else {
            ElementDefn contentDefn = (ElementDefn)this.oldElement.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.oldElement, contentDefn.getTriggerDefnSet(), false));
        }
        return list;
    }

    protected List getPostTasks() {
        ReportItem compoundElement;
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        DesignElement container = this.focus.getElement();
        if ((container instanceof TableItem || container instanceof TableGroup || container instanceof TableRow) && (compoundElement = LayoutUtil.getCompoundContainer(container)) != null) {
            retValue.add(new LayoutRecordTask(this.module, compoundElement));
        }
        NotificationEvent event = null;
        event = this.getContainerEvent();
        retValue.add(new NotificationRecordTask(container, event));
        if (this.state != 2) {
            if (this.isSelector(this.newElement)) {
                retValue.add(new NotificationRecordTask(this.newElement, event, container.getRoot()));
            }
        } else if (this.isSelector(this.oldElement)) {
            retValue.add(new NotificationRecordTask(this.oldElement, event, container.getRoot()));
        }
        return retValue;
    }

    protected NotificationEvent getContainerEvent() {
        ContentReplaceEvent event = null;
        event = this.state != 2 ? new ContentReplaceEvent(this.focus, this.oldElement, this.newElement) : new ContentReplaceEvent(this.focus, this.newElement, this.oldElement);
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        return event;
    }
}

