/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatiblePropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.xml.sax.SAXException;

public class Base64PropertyState
extends CompatiblePropertyState {
    private static Base64 base;
    private final String charSet;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.parser.Base64PropertyState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        base = new Base64();
    }

    Base64PropertyState(ModuleParserHandler theHandler, DesignElement element, String charSet) {
        super(theHandler, element);
        if (!$assertionsDisabled && charSet == null) {
            throw new AssertionError();
        }
        this.charSet = charSet;
    }

    Base64PropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct, String charSet) {
        super(theHandler, element, propDefn, struct);
        if (!$assertionsDisabled && charSet == null) {
            throw new AssertionError();
        }
        this.charSet = charSet;
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        value = this.getDecodedBase64Value(value);
        super.doEnd(value);
    }

    private String getDecodedBase64Value(String value) {
        String encodedValue = StringUtil.trimString(value);
        if (encodedValue == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\s");
        Matcher m = p.matcher(encodedValue);
        encodedValue = m.replaceAll("");
        byte[] data = null;
        try {
            data = base.decode(encodedValue.getBytes(this.charSet));
            return new String(data, this.charSet);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }
}

