/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.EncryptionException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.EncryptionRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class EncryptionCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.EncryptionCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public EncryptionCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setEncryption(String propName, String encryptionID) throws SemanticException {
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
        if (propDefn == null) {
            throw new PropertyNameException(this.element, propName);
        }
        this.setEncryption(propDefn, encryptionID);
    }

    public void setEncryption(ElementPropertyDefn propDefn, String encryptionID) throws SemanticException {
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!propDefn.isEncryptable()) {
            throw new EncryptionException(this.element, "Error.EncryptionException.INVALID_ENCRYPTABLE_PROPERTY", new String[]{this.element.getIdentifier(), propDefn.getName()});
        }
        if ((encryptionID = StringUtil.trimString(encryptionID)) != null && MetaDataDictionary.getInstance().getEncryptionHelper(encryptionID) == null) {
            throw new EncryptionException(this.element, "Error.EncryptionException.INVALID_ENCRYPTION", new String[]{encryptionID});
        }
        String oldEncryption = this.element.getLocalEncryptionID(propDefn);
        if (encryptionID == null && oldEncryption == null || encryptionID != null && encryptionID.equals(oldEncryption)) {
            return;
        }
        EncryptionRecord record = new EncryptionRecord(this.module, this.element, propDefn, encryptionID);
        this.getActivityStack().execute(record);
    }
}

