/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.text.DecimalFormat;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;

final class LogAxisLabelTextProvider
extends AxisLabelTextProvider {
    private NumberDataElement nde = NumberDataElementImpl.create(0.0);
    private double dMinValue;
    private double dStep;
    private DecimalFormat df;

    protected LogAxisLabelTextProvider(OneAxis oax) {
        super(oax);
    }

    protected void init() {
        this.dMinValue = Methods.asDouble(this.sc.getMinimum());
        this.dStep = Methods.asDouble(this.sc.getStep());
        if (this.axModel.getFormatSpecifier() == null) {
            this.df = this.sc.computeDecimalFormat(this.dMinValue, this.dStep);
        }
    }

    public String getLabelText(int index) throws ChartException {
        double dValue = this.dMinValue * Math.pow(this.dStep, index);
        this.nde.setValue(dValue);
        return ValueFormatter.format(this.nde, this.axModel.getFormatSpecifier(), this.oax.getRunTimeContext().getULocale(), this.df);
    }
}

