/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.internal.datafeed.GroupingLookupHelper;
import org.eclipse.birt.chart.internal.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;
import org.eclipse.birt.chart.internal.datafeed.UserDataSetProcessor;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataProcessor {
    private final RunTimeContext rtc;
    private final IActionEvaluator iae;

    public DataProcessor(RunTimeContext rtc, IActionEvaluator iae) {
        this.rtc = rtc;
        this.iae = iae;
    }

    public static String[] getSeriesTriggerExpressions(Series se, IActionEvaluator iae) {
        ArrayList<String> rt = new ArrayList<String>();
        if (se != null && iae != null) {
            Iterator itr = se.getTriggers().iterator();
            while (itr.hasNext()) {
                Trigger tg = (Trigger)itr.next();
                String[] expra = iae.getActionExpressions(tg.getAction(), StructureSource.createSeries(se));
                if (expra == null || expra.length <= 0) continue;
                int i = 0;
                while (i < expra.length) {
                    String expr = expra[i];
                    if (expr != null && expr.trim().length() > 0 && !rt.contains(expr)) {
                        rt.add(expr);
                    }
                    ++i;
                }
            }
        }
        if (rt.size() > 0) {
            return rt.toArray(new String[rt.size()]);
        }
        return null;
    }

    private GroupKey[] findGroupKeys(Chart cm, GroupingLookupHelper lhmLookup) {
        if (cm instanceof ChartWithAxes) {
            return this.findGroupKeys((ChartWithAxes)cm, lhmLookup);
        }
        if (cm instanceof ChartWithoutAxes) {
            return this.findGroupKeys((ChartWithoutAxes)cm, lhmLookup);
        }
        return null;
    }

    private GroupKey[] findGroupKeys(ChartWithoutAxes cwoa, GroupingLookupHelper lhmLookup) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        elSD = sd.getSeriesDefinitions();
        int i = 0;
        while (i < elSD.size()) {
            GroupKey sortKey;
            String sExpression;
            sd = (SeriesDefinition)elSD.get(i);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition != null && (sExpression = qOrthogonalSeriesDefinition.getDefinition()) != null && sExpression.trim().length() > 0 && !alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) {
                sortKey.setKeyIndex(lhmLookup.findIndex(sExpression, lhmLookup.getOrthogonalAggregationExpression(sd)));
                alKeys.add(sortKey);
            }
            ++i;
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    private GroupKey[] findGroupKeys(ChartWithAxes cwa, GroupingLookupHelper lhmLookup) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int i = 0;
        while (i < axaOrthogonal.length) {
            EList elSD = axaOrthogonal[i].getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                GroupKey sortKey;
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition != null && (sExpression = qOrthogonalSeriesDefinition.getDefinition()) != null && sExpression.trim().length() > 0 && !alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) {
                    sortKey.setKeyIndex(lhmLookup.findIndex(sExpression, lhmLookup.getOrthogonalAggregationExpression(sd)));
                    alKeys.add(sortKey);
                }
                ++j;
            }
            ++i;
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    protected ResultSetWrapper mapToChartResultSet(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        GroupingLookupHelper lhmLookup = new GroupingLookupHelper(cm, this.iae, this.rtc.getULocale());
        List co = lhmLookup.getExpressions();
        int iColumnCount = co.size();
        ArrayList<Object[]> liResultSet = new ArrayList<Object[]>();
        if (idre.first()) {
            int count = 0;
            int MAX_ROW_COUNT = ChartUtil.getSupportedMaxRowCount(this.rtc);
            while (count++ < MAX_ROW_COUNT) {
                Object[] oaTuple = new Object[iColumnCount];
                Iterator it = co.iterator();
                int iColumnIndex = 0;
                while (it.hasNext()) {
                    oaTuple[iColumnIndex++] = idre.evaluate((String)it.next());
                }
                liResultSet.add(oaTuple);
                if (idre.next()) continue;
            }
        }
        GroupKey[] groupKeys = this.findGroupKeys(cm, lhmLookup);
        ResultSetWrapper rsw = new ResultSetWrapper(lhmLookup, liResultSet, groupKeys);
        SeriesDefinition sdBase = null;
        boolean bBaseGrouping = false;
        AggregationExpressionHelper aggHelper = new AggregationExpressionHelper();
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            Axis[] axaBase = cwa.getBaseAxes();
            Axis[] axaOrthogonal = null;
            int j = 0;
            while (j < axaBase.length) {
                sdBase = (SeriesDefinition)axaBase[j].getSeriesDefinitions().get(0);
                axaOrthogonal = cwa.getOrthogonalAxes(axaBase[j], true);
                bBaseGrouping = rsw.getRowCount() > 0 && sdBase.getGrouping() != null && sdBase.getGrouping().isEnabled();
                int i = 0;
                while (i < axaOrthogonal.length) {
                    aggHelper.addSeriesDefinitions(axaOrthogonal[i].getSeriesDefinitions(), lhmLookup);
                    ++i;
                }
                ++j;
            }
        } else if (cm instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            sdBase = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            bBaseGrouping = rsw.getRowCount() > 0 && sdBase.getGrouping() != null && sdBase.getGrouping().isEnabled();
            aggHelper.addSeriesDefinitions(sdBase.getSeriesDefinitions(), lhmLookup);
        }
        if (bBaseGrouping && aggHelper.getDataDefinitionsForBaseGrouping().size() > 0) {
            aggHelper.addAggregation(sdBase.getGrouping().getAggregateExpression(), aggHelper.getDataDefinitionsForBaseGrouping());
        }
        rsw.applyBaseSeriesSortingAndGrouping(sdBase, aggHelper.getAggregations(), aggHelper.getDataDefinitions());
        aggHelper.dispose();
        return rsw;
    }

    public void generateRuntimeSeries(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        ResultSetWrapper rsw = this.mapToChartResultSet(idre, cm);
        cm.clearSections(3);
        if (cm instanceof ChartWithAxes) {
            this.generateRuntimeSeries((ChartWithAxes)cm, rsw);
        } else if (cm instanceof ChartWithoutAxes) {
            this.generateRuntimeSeries((ChartWithoutAxes)cm, rsw);
        }
    }

    private void generateRuntimeSeries(ChartWithoutAxes cwoa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List columns;
        int iGroupCount = rsw.getGroupCount();
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = (Series)EcoreUtil.copy((EObject)seBaseDesignSeries);
        sdBase.getSeries().add((Object)seBaseRuntimeSeries);
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = rsw.getLookupHelper().getExpressions()).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        elSD = sdBase.getSeriesDefinitions();
        int j = 0;
        while (j < elSD.size()) {
            SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
            qy = sd.getQuery();
            if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                ++iOrthogonalSeriesDefinitionCount;
            }
            ++j;
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwoa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            elSD = sdBase.getSeriesDefinitions();
            int j2 = 0;
            while (j2 < elSD.size()) {
                SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j2);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                Series seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                this.fillSeriesDataSet(cwoa, seOrthogonalRuntimeSeries, rsw.getSubset(seOrthogonalDesignSeries.getDataDefinition(), aggExp), triggerExprs, rsw.getSubset(triggerExprs, aggExp));
                seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                ++j2;
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            elSD = sdBase.getSeriesDefinitions();
            int j3 = 0;
            while (j3 < elSD.size()) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j3);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                int k = 0;
                while (k < iGroupCount) {
                    seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                    Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, seOrthogonalDesignSeries.getDataDefinition(), aggExp), rsw.getSubset(k, triggerExprs, aggExp));
                    odata[3] = new Integer(rsw.getGroupRowCount(k));
                    odata[4] = new Integer(k);
                    odata[5] = triggerExprs;
                    orthogonalDataList.add(odata);
                    ++k;
                }
                ++j3;
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            int i = 0;
            while (i < orthogonalData.length) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i])[3] = ds;
                ++i;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            int odx = 0;
            elSD = sdBase.getSeriesDefinitions();
            int j4 = 0;
            while (j4 < elSD.size()) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j4);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                int k = 0;
                while (k < iGroupCount) {
                    Object[] odata = (Object[])orthogonalData[odx];
                    seOrthogonalRuntimeSeries = (Series)odata[2];
                    this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                    qy = sdOrthogonal.getQuery();
                    String string = sExpression = qy == null ? "" : qy.getDefinition();
                    if (sExpression == null) {
                        sExpression = "";
                    }
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression, aggExp));
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                    ++odx;
                    ++k;
                }
                ++j4;
            }
        }
    }

    private void generateRuntimeSeries(ChartWithAxes cwa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List columns;
        int iGroupCount = rsw.getGroupCount();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = (Series)EcoreUtil.copy((EObject)seBaseDesignSeries);
        sdBase.getSeries().add((Object)seBaseRuntimeSeries);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = rsw.getLookupHelper().getExpressions()).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        int i = 0;
        while (i < axaOrthogonal.length) {
            elSD = axaOrthogonal[i].getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                qy = sd.getQuery();
                if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                    ++iOrthogonalSeriesDefinitionCount;
                }
                ++j;
            }
            ++i;
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            int i2 = 0;
            while (i2 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i2].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    Series seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    this.fillSeriesDataSet(cwa, seOrthogonalRuntimeSeries, rsw.getSubset(seOrthogonalDesignSeries.getDataDefinition(), aggExp), triggerExprs, rsw.getSubset(triggerExprs, aggExp));
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                    ++j;
                }
                ++i2;
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            int i3 = 0;
            while (i3 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i3].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    int k = 0;
                    while (k < iGroupCount) {
                        seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                        Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, seOrthogonalDesignSeries.getDataDefinition(), aggExp), rsw.getSubset(k, triggerExprs, aggExp));
                        odata[3] = new Integer(rsw.getGroupRowCount(k));
                        odata[4] = new Integer(k);
                        odata[5] = triggerExprs;
                        orthogonalDataList.add(odata);
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            int i4 = 0;
            while (i4 < orthogonalData.length) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i4])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i4])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i4])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i4])[3] = ds;
                ++i4;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            int odx = 0;
            int i5 = 0;
            while (i5 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i5].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    int k = 0;
                    while (k < iGroupCount) {
                        Object[] odata = (Object[])orthogonalData[odx];
                        seOrthogonalRuntimeSeries = (Series)odata[2];
                        this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                        qy = sdOrthogonal.getQuery();
                        String string = sExpression = qy == null ? "" : qy.getDefinition();
                        if (sExpression == null) {
                            sExpression = "";
                        }
                        seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression, aggExp));
                        sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                        ++odx;
                        ++k;
                    }
                    ++j;
                }
                ++i5;
            }
        }
    }

    private DataSet adjustDataSet(DataSet ds, int maxcount, List indexMap, DataSet[] userDs) {
        ds = this.adjustEachDataSet(ds, indexMap);
        if (userDs != null && userDs.length > 0) {
            int i = 0;
            while (i < userDs.length) {
                DataSet usds;
                userDs[i] = usds = this.adjustEachDataSet(userDs[i], indexMap);
                ++i;
            }
        }
        return ds;
    }

    private DataSet adjustEachDataSet(DataSet ds, List indexMap) {
        int[] indexArray = new int[indexMap.size()];
        int i = 0;
        while (i < indexArray.length) {
            indexArray[i] = (Integer)indexMap.get(i);
            ++i;
        }
        Object oContent = ds.getValues();
        if (ds instanceof NumberDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i2 = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i2++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i2 = 0;
                while (i2 < objBuffer.length) {
                    co.add(objBuffer[i2]);
                    ++i2;
                }
            } else if (oContent instanceof double[]) {
                double[] da = (double[])oContent;
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                int i3 = 0;
                while (i3 < da.length) {
                    int idx = indexArray[i3];
                    if (idx != -1) {
                        doubleBuffer[idx] = da[i3];
                    }
                    ++i3;
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Double[]) {
                Double[] dda = (Double[])oContent;
                Double[] doubleBuffer = new Double[indexArray.length];
                int i4 = 0;
                while (i4 < dda.length) {
                    int idx = indexArray[i4];
                    if (idx != -1) {
                        doubleBuffer[idx] = dda[i4];
                    }
                    ++i4;
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Number) {
                double[] da = new double[]{((Number)oContent).doubleValue()};
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                int idx = indexArray[0];
                if (idx != -1) {
                    doubleBuffer[idx] = da[0];
                }
                ds.setValues(doubleBuffer);
            }
        } else if (ds instanceof DateTimeDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i5 = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i5++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i5 = 0;
                while (i5 < objBuffer.length) {
                    co.add(objBuffer[i5]);
                    ++i5;
                }
            } else if (oContent instanceof long[]) {
                long[] la = (long[])oContent;
                double[] longBuffer = new double[indexArray.length];
                Arrays.fill(longBuffer, Double.NaN);
                int i6 = 0;
                while (i6 < la.length) {
                    int idx = indexArray[i6];
                    if (idx != -1) {
                        longBuffer[idx] = la[i6];
                    }
                    ++i6;
                }
                ds.setValues(longBuffer);
            } else if (oContent instanceof Calendar[]) {
                Calendar[] ca = (Calendar[])oContent;
                Calendar[] calendarBuffer = new Calendar[indexArray.length];
                int i7 = 0;
                while (i7 < ca.length) {
                    int idx = indexArray[i7];
                    if (idx != -1) {
                        calendarBuffer[idx] = ca[i7];
                    }
                    ++i7;
                }
                ds.setValues(calendarBuffer);
            }
        } else if (ds instanceof TextDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i8 = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i8++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i8 = 0;
                while (i8 < objBuffer.length) {
                    co.add(objBuffer[i8]);
                    ++i8;
                }
            } else if (oContent instanceof String[]) {
                String[] sa = (String[])oContent;
                String[] stringBuffer = new String[indexArray.length];
                int i9 = 0;
                while (i9 < sa.length) {
                    int idx = indexArray[i9];
                    if (idx != -1) {
                        stringBuffer[idx] = sa[i9];
                    }
                    ++i9;
                }
                ds.setValues(stringBuffer);
            }
        } else if (oContent instanceof Collection) {
            Collection co = (Collection)oContent;
            Object[] objBuffer = new Object[indexArray.length];
            int i10 = 0;
            Iterator itr = co.iterator();
            while (itr.hasNext()) {
                int idx;
                Object o = itr.next();
                if ((idx = indexArray[i10++]) == -1) continue;
                objBuffer[idx] = o;
            }
            co.clear();
            i10 = 0;
            while (i10 < objBuffer.length) {
                co.add(objBuffer[i10]);
                ++i10;
            }
        } else if (oContent instanceof Object[]) {
            Object[] oa = (Object[])oContent;
            Object[] objectBuffer = new Object[indexArray.length];
            int i11 = 0;
            while (i11 < oa.length) {
                int idx = indexArray[i11];
                if (idx != -1) {
                    objectBuffer[idx] = oa[i11];
                }
                ++i11;
            }
            ds.setValues(objectBuffer);
        }
        return ds;
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        return this.populateSeriesDataSet(seRuntime, rsds, null);
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds, IResultSetDataSet userRsds) throws ChartException {
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((Object)pex));
        }
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        DataSet[] usds = null;
        if (userRsds != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            usds = tdsp.populate(userRsds);
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = ds;
        objectArray[1] = idsp;
        objectArray[2] = seRuntime;
        objectArray[6] = usds;
        return objectArray;
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds) throws ChartException {
        this.fillSeriesDataSet(idsp, seRuntime, ds, null, null);
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds, String[] userKeys, DataSet[] userDs) throws ChartException {
        ScriptHandler sh = this.rtc.getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        seRuntime.setDataSet(ds);
        if (userDs != null && userKeys != null) {
            int i = 0;
            while (i < Math.min(userDs.length, userKeys.length)) {
                seRuntime.setDataSet(userKeys[i], userDs[i]);
                ++i;
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        this.fillSeriesDataSet(cm, seRuntime, rsds, null, null);
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds, String[] userKeys, IResultSetDataSet userRsds) throws ChartException {
        ScriptHandler sh = this.rtc.getScriptHandler();
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((Object)pex));
        }
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        seRuntime.setDataSet(ds);
        if (userRsds != null && userKeys != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            DataSet[] usds = tdsp.populate(userRsds);
            int i = 0;
            while (i < Math.min(usds.length, userKeys.length)) {
                seRuntime.setDataSet(userKeys[i], usds[i]);
                ++i;
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }

    class AggregationExpressionHelper {
        private List aggregationExpsList = new ArrayList(3);
        private List querysList = new ArrayList(3);
        private List baseQueryList = new ArrayList(3);

        AggregationExpressionHelper() {
        }

        public void addAggregation(String exp, List querys) {
            int i = 0;
            while (i < querys.size()) {
                this.aggregationExpsList.add(exp);
                this.querysList.add(querys.get(i));
                ++i;
            }
        }

        public String[] getAggregations() {
            return this.aggregationExpsList.toArray(new String[this.aggregationExpsList.size()]);
        }

        public String[] getDataDefinitions() {
            return this.querysList.toArray(new String[this.querysList.size()]);
        }

        public List getDataDefinitionsForBaseGrouping() {
            return this.baseQueryList;
        }

        public void dispose() {
            this.aggregationExpsList.clear();
            this.querysList.clear();
        }

        public boolean isEmpty() {
            return this.aggregationExpsList.isEmpty() || this.querysList.isEmpty();
        }

        public void addSeriesDefinitions(EList elSD, GroupingLookupHelper lhmLookup) throws ChartException {
            int k = 0;
            while (k < elSD.size()) {
                SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(k);
                Series series = sdOrthogonal.getDesignTimeSeries();
                List qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
                String strOrtAgg = lhmLookup.getOrthogonalAggregationExpression(sdOrthogonal);
                if (strOrtAgg != null) {
                    this.addAggregation(strOrtAgg, qlist);
                } else {
                    this.baseQueryList.addAll(qlist);
                }
                ++k;
            }
        }
    }
}

