/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Point;

public class LegendItemHints
implements IConstants {
    private final Point location;
    private final double width;
    private final double height;
    private final String text;
    private final String extraText;
    private final double extraHeight;
    private final int type;
    private final int categoryIndex;

    public LegendItemHints(int type, Point loc, double width, double height, String text, int categoryIndex) {
        this(type, loc, width, height, text, 0.0, null, categoryIndex);
    }

    public LegendItemHints(int type, Point loc, double width, double height, String text, double extraHeight, String extraText) {
        this(type, loc, width, height, text, extraHeight, extraText, 0);
    }

    public LegendItemHints(int type, Point loc, double width, double height, String text, double extraHeight, String extraText, int categoryIndex) {
        this.type = type;
        this.location = loc;
        this.width = width;
        this.height = height;
        this.text = text;
        this.extraText = extraText;
        this.extraHeight = extraHeight;
        this.categoryIndex = categoryIndex;
    }

    public int getType() {
        return this.type;
    }

    public Point getLocation() {
        return this.location;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getLeft() {
        if (this.location != null) {
            return this.location.getX();
        }
        return 0.0;
    }

    public double getTop() {
        if (this.location != null) {
            return this.location.getY();
        }
        return 0.0;
    }

    public String getText() {
        return this.text;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public double getExtraHeight() {
        return this.extraHeight;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }
}

