/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import javax.tools.Diagnostic;

public class CompilerError {
    private Diagnostic.Kind kind;
    private int startline;
    private int startcolumn;
    private int endline;
    private int endcolumn;
    private String file;
    private String message;

    public CompilerError(String file, boolean error, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this(file, error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING, startline, startcolumn, endline, endcolumn, message);
    }

    public CompilerError(String file, Diagnostic.Kind kind, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this.kind = kind;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
        this.file = file;
        this.message = message;
    }

    public CompilerError(String message) {
        this.message = message;
        this.kind = Diagnostic.Kind.WARNING;
    }

    public CompilerError(String message, boolean error) {
        this.message = message;
        this.kind = error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
    }

    public CompilerError(String message, Diagnostic.Kind kind) {
        this.kind = kind;
        this.message = message;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isError() {
        return this.kind == Diagnostic.Kind.ERROR;
    }

    public int getStartLine() {
        return this.startline;
    }

    public int getStartColumn() {
        return this.startcolumn;
    }

    public int getEndLine() {
        return this.endline;
    }

    public int getEndColumn() {
        return this.endcolumn;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.file != null) {
            if (this.startline != 0) {
                if (this.startcolumn != 0) {
                    return this.file + ":" + "[" + this.startline + "," + this.startcolumn + "] " + this.message;
                }
                return this.file + ":" + "[" + this.startline + "] " + this.message;
            }
            return this.file + ": " + this.message;
        }
        return this.message;
    }

    public Diagnostic.Kind getKind() {
        return this.kind;
    }
}

