/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.xml.Resolver;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractXmlMojo
extends AbstractMojo {
    private MavenProject project;
    private Settings settings;
    private File basedir;
    private String[] catalogs;
    private ResourceManager locator;
    private boolean locatorInitialized;

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getBasedir() {
        return this.basedir;
    }

    protected File asAbsoluteFile(File f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getBasedir(), f.getPath());
    }

    protected void setCatalogs(List pCatalogFiles, List pCatalogUrls) {
        if (this.catalogs == null || this.catalogs.length == 0) {
            return;
        }
        for (int i = 0; i < this.catalogs.length; ++i) {
            try {
                URL url = new URL(this.catalogs[i]);
                pCatalogUrls.add(url);
                continue;
            }
            catch (MalformedURLException e) {
                pCatalogFiles.add(this.asAbsoluteFile(new File(this.catalogs[i])));
            }
        }
    }

    protected Resolver getResolver() throws MojoExecutionException {
        ArrayList catalogFiles = new ArrayList();
        ArrayList catalogUrls = new ArrayList();
        this.setCatalogs(catalogFiles, catalogUrls);
        return new Resolver(this.getBasedir(), catalogFiles, catalogUrls, this.getLocator(), this.getLog().isDebugEnabled());
    }

    protected String[] getFileNames(File pDir, String[] pIncludes, String[] pExcludes) throws MojoFailureException {
        if (pDir == null) {
            throw new MojoFailureException("A ValidationSet or TransformationSet requires a nonempty 'dir' child element.");
        }
        File dir = this.asAbsoluteFile(pDir);
        if (!dir.isDirectory()) {
            this.getLog().warn((CharSequence)("The directory " + dir.getPath() + ", which is a base directory of a ValidationSet or TransformationSet, does not exist."));
            return new String[0];
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        if (pIncludes != null && pIncludes.length > 0) {
            ds.setIncludes(pIncludes);
        }
        if (pExcludes != null && pExcludes.length > 0) {
            ds.setExcludes(pExcludes);
        }
        ds.scan();
        return ds.getIncludedFiles();
    }

    protected File[] asFiles(File pDir, String[] pFileNames) {
        if (pFileNames == null) {
            return new File[0];
        }
        File dir = this.asAbsoluteFile(pDir);
        File[] result = new File[pFileNames.length];
        for (int i = 0; i < pFileNames.length; ++i) {
            result[i] = new File(dir, pFileNames[i]);
        }
        return result;
    }

    protected File[] getFiles(File pDir, String[] pIncludes, String[] pExcludes) throws MojoFailureException {
        return this.asFiles(pDir, this.getFileNames(pDir, pIncludes, pExcludes));
    }

    protected String[] getExcludes(String[] origExcludes, boolean skipDefaultExcludes) {
        if (skipDefaultExcludes) {
            return origExcludes;
        }
        String[] defaultExcludes = FileUtils.getDefaultExcludes();
        if (origExcludes == null || origExcludes.length == 0) {
            return defaultExcludes;
        }
        String[] result = new String[origExcludes.length + defaultExcludes.length];
        System.arraycopy(origExcludes, 0, result, 0, origExcludes.length);
        System.arraycopy(defaultExcludes, 0, result, origExcludes.length, defaultExcludes.length);
        return result;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    private void setProperty(List pProperties, String pKey, String pValue) {
        if (pProperties != null) {
            pProperties.add(pKey);
            pProperties.add(System.getProperty(pKey));
        }
        if (pValue == null) {
            System.getProperties().remove(pKey);
        } else {
            System.setProperty(pKey, pValue);
        }
    }

    protected Object activateProxy() {
        if (this.settings == null) {
            return null;
        }
        Proxy proxy = this.settings.getActiveProxy();
        if (proxy == null) {
            return null;
        }
        ArrayList properties = new ArrayList();
        String protocol = proxy.getProtocol();
        String prefix = this.isEmpty(protocol) ? "" : protocol + ".";
        String host = proxy.getHost();
        String hostProperty = prefix + "proxyHost";
        String hostValue = this.isEmpty(host) ? null : host;
        this.setProperty(properties, hostProperty, hostValue);
        int port = proxy.getPort();
        String portProperty = prefix + "proxyPort";
        String portValue = port == 0 || port == -1 ? null : String.valueOf(port);
        this.setProperty(properties, portProperty, portValue);
        String username = proxy.getUsername();
        String userProperty = prefix + "proxyUser";
        String userValue = this.isEmpty(username) ? null : username;
        this.setProperty(properties, userProperty, userValue);
        String password = proxy.getPassword();
        String passwordProperty = prefix + "proxyPassword";
        String passwordValue = this.isEmpty(password) ? null : password;
        this.setProperty(properties, passwordProperty, passwordValue);
        String nonProxyHosts = proxy.getNonProxyHosts();
        String nonProxyHostsProperty = prefix + "nonProxyHosts";
        String nonProxyHostsValue = this.isEmpty(nonProxyHosts) ? null : nonProxyHosts.replace(',', '|');
        this.setProperty(properties, nonProxyHostsProperty, nonProxyHostsValue);
        this.getLog().debug((CharSequence)("Proxy settings: " + hostProperty + "=" + hostValue + ", " + portProperty + "=" + portValue + ", " + userProperty + "=" + userValue + ", " + passwordProperty + "=" + (passwordValue == null ? "null" : "<PasswordNotLogged>") + ", " + nonProxyHostsProperty + "=" + nonProxyHostsValue));
        return properties;
    }

    protected void passivateProxy(Object pProperties) {
        if (pProperties == null) {
            return;
        }
        List properties = (List)pProperties;
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)iter.next();
            this.setProperty(null, key, value);
        }
    }

    protected URL getResource(String pResource) throws MojoFailureException {
        try {
            return this.getLocator().getResource(pResource).getURL();
        }
        catch (ResourceNotFoundException exception) {
            throw new MojoFailureException("Could not find stylesheet: " + pResource);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while locating resource: " + pResource);
        }
    }

    protected ResourceManager getLocator() {
        if (!this.locatorInitialized) {
            this.locator.addSearchPath("file", this.getBasedir().getAbsolutePath());
            this.locatorInitialized = true;
        }
        return this.locator;
    }
}

