/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.xml.AbstractXmlMojo;
import org.codehaus.mojo.xml.Resolver;
import org.codehaus.mojo.xml.validation.ValidationErrorHandler;
import org.codehaus.mojo.xml.validation.ValidationSet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@Mojo(name="validate", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class ValidateMojo
extends AbstractXmlMojo {
    private static final String INTRINSIC_NS_URI = "http://componentcorp.com/xml/ns/xml-model/1.0";
    @Parameter
    private ValidationSet[] validationSets;

    private Schema getSchema(Resolver pResolver, ValidationSet pValidationSet) throws MojoExecutionException {
        SAXSource saxSource;
        String schemaLanguage = pValidationSet.getSchemaLanguage();
        if (schemaLanguage == null || "".equals(schemaLanguage)) {
            schemaLanguage = "http://www.w3.org/2001/XMLSchema";
        }
        String publicId = pValidationSet.getPublicId();
        String systemId = pValidationSet.getSystemId();
        if (!(publicId != null && !"".equals(publicId) || systemId != null && !"".equals(systemId) || INTRINSIC_NS_URI.equals(schemaLanguage))) {
            return null;
        }
        if (INTRINSIC_NS_URI.equals(schemaLanguage) && (publicId == null || "".equals(publicId)) && (systemId == null || "".equals(systemId))) {
            saxSource = null;
        } else {
            this.getLog().debug((CharSequence)("Loading schema with public Id " + publicId + ", system Id " + systemId));
            InputSource inputSource = null;
            if (pResolver != null) {
                try {
                    inputSource = pResolver.resolveEntity(publicId, systemId);
                }
                catch (SAXException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (inputSource == null) {
                inputSource = new InputSource();
                inputSource.setPublicId(pResolver.filterPossibleURI(publicId));
                inputSource.setSystemId(pResolver.filterPossibleURI(systemId));
            }
            saxSource = new SAXSource(inputSource);
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
            if (pResolver != null) {
                schemaFactory.setResourceResolver(pResolver);
            }
            return saxSource == null ? schemaFactory.newSchema() : schemaFactory.newSchema(saxSource);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Failed to load schema with public ID " + publicId + ", system ID " + systemId + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void validate(Resolver pResolver, ValidationSet pValidationSet, Schema pSchema, File pFile, ValidationErrorHandler errorHandler) throws MojoExecutionException {
        errorHandler.setContext(pFile);
        try {
            if (pSchema == null) {
                this.getLog().debug((CharSequence)("Parsing " + pFile.getPath()));
                this.parse(pResolver, pValidationSet, pFile, errorHandler);
            } else {
                this.getLog().debug((CharSequence)("Validating " + pFile.getPath()));
                Validator validator = pSchema.newValidator();
                validator.setErrorHandler(errorHandler);
                if (pResolver != null) {
                    validator.setResourceResolver(pResolver);
                }
                if (pValidationSet.isXincludeAware()) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    spf.setNamespaceAware(true);
                    spf.setXIncludeAware(pValidationSet.isXincludeAware());
                    InputSource isource = new InputSource(pFile.toURI().toASCIIString());
                    XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                    xmlReader.setEntityResolver(pResolver);
                    validator.validate(new SAXSource(xmlReader, isource));
                } else {
                    validator.validate(new StreamSource(pFile));
                }
            }
        }
        catch (SAXParseException e) {
            try {
                errorHandler.fatalError(e);
            }
            catch (SAXException se) {
                throw new MojoExecutionException("While parsing " + pFile + ": " + e.getMessage(), (Exception)se);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("While parsing " + pFile + ": " + e.getMessage(), e);
        }
    }

    private SAXParserFactory newSAXParserFactory(ValidationSet pValidationSet) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(pValidationSet.isValidating());
        if (pValidationSet.isValidating()) {
            try {
                spf.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {}
        } else {
            try {
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        spf.setNamespaceAware(true);
        return spf;
    }

    private void parse(Resolver pResolver, ValidationSet pValidationSet, File pFile, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        XMLReader xr = this.newSAXParserFactory(pValidationSet).newSAXParser().getXMLReader();
        if (pResolver != null) {
            xr.setEntityResolver(pResolver);
        }
        xr.setErrorHandler(errorHandler);
        xr.parse(pFile.toURI().toURL().toExternalForm());
    }

    private void validate(Resolver pResolver, ValidationSet pValidationSet, ValidationErrorHandler errorHandler) throws MojoExecutionException, MojoFailureException {
        Schema schema = this.getSchema(pResolver, pValidationSet);
        File[] files = this.getFiles(pValidationSet.getDir(), pValidationSet.getIncludes(), this.getExcludes(pValidationSet.getExcludes(), pValidationSet.isSkipDefaultExcludes()));
        if (files.length == 0) {
            this.getLog().info((CharSequence)("No matching files found for ValidationSet with public ID " + pValidationSet.getPublicId() + ", system ID " + pValidationSet.getSystemId() + "."));
        }
        for (int i = 0; i < files.length; ++i) {
            this.validate(pResolver, pValidationSet, schema, files[i], errorHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipping()) {
            this.getLog().debug((CharSequence)"Skipping execution, as demanded by user.");
            return;
        }
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        if (this.validationSets == null || this.validationSets.length == 0) {
            throw new MojoFailureException("No ValidationSets configured.");
        }
        this.checkCatalogHandling();
        Object oldProxySettings = this.activateProxy();
        try {
            Resolver resolver = this.getResolver();
            for (int i = 0; i < this.validationSets.length; ++i) {
                ValidationSet validationSet = this.validationSets[i];
                resolver.setXincludeAware(validationSet.isValidating());
                resolver.setValidating(validationSet.isValidating());
                this.validate(resolver, validationSet, errorHandler);
            }
            List<ValidationErrorHandler.ErrorRecord> errorRecords = errorHandler.getErrors();
            if (!errorRecords.isEmpty()) {
                StringBuffer message = new StringBuffer();
                for (ValidationErrorHandler.ErrorRecord error : errorRecords) {
                    this.appendMessage(message, error);
                }
                if (errorHandler.getErrorCount() + errorHandler.getFatalCount() > 0) {
                    throw new MojoExecutionException(message.toString());
                }
                this.getLog().warn((CharSequence)message.toString());
            }
        }
        finally {
            this.passivateProxy(oldProxySettings);
        }
    }

    private void appendMessage(StringBuffer messageBuffer, ValidationErrorHandler.ErrorRecord error) {
        String location;
        SAXParseException e = error.getException();
        String publicId = e.getPublicId();
        String systemId = e.getSystemId();
        int lineNum = e.getLineNumber();
        int colNum = e.getColumnNumber();
        if (publicId == null && systemId == null && lineNum == -1 && colNum == -1) {
            location = "";
        } else {
            StringBuffer loc = new StringBuffer();
            String sep = "";
            if (publicId != null) {
                loc.append("Public ID ");
                loc.append(publicId);
                sep = ", ";
            }
            if (systemId != null) {
                loc.append(sep);
                loc.append(systemId);
                sep = ", ";
            }
            if (lineNum != -1) {
                loc.append(sep);
                loc.append("line ");
                loc.append(lineNum);
                sep = ", ";
            }
            if (colNum != -1) {
                loc.append(sep);
                loc.append(" column ");
                loc.append(colNum);
                sep = ", ";
            }
            location = loc.toString();
        }
        messageBuffer.append("While parsing ");
        messageBuffer.append(error.getContext().getPath());
        messageBuffer.append("".equals(location) ? "" : ", at " + location);
        messageBuffer.append(": ");
        messageBuffer.append(error.getType().toString());
        messageBuffer.append(": ");
        messageBuffer.append(e.getMessage());
        String lineSep = System.getProperty("line.separator");
        messageBuffer.append(lineSep);
    }
}

