/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public abstract class AbstractSimplifiedTypeLookup
implements ITypeLookupExtension {
    private boolean isStatic;
    private Expression currentExpression;

    protected boolean isStatic() {
        return this.isStatic;
    }

    protected Expression getCurrentExpression() {
        return this.currentExpression;
    }

    protected boolean isQuotedString() {
        return this.currentExpression instanceof GStringExpression || this.currentExpression.getText().length() != this.currentExpression.getLength();
    }

    public final TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        return this.lookupType(node, scope, objectExpressionType, false);
    }

    public final TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        ClassNode declaringType;
        if (objectExpressionType != null) {
            declaringType = objectExpressionType;
        } else {
            declaringType = scope.getDelegateOrThis();
            if (declaringType == null && (declaringType = scope.getEnclosingTypeDeclaration()) == null) {
                declaringType = VariableScope.OBJECT_CLASS_NODE;
            }
        }
        this.isStatic = isStaticObjectExpression;
        this.currentExpression = node;
        TypeAndDeclaration tAndD = null;
        if (node instanceof ConstantExpression || node instanceof GStringExpression || node instanceof VariableExpression) {
            tAndD = this.lookupTypeAndDeclaration(declaringType, node.getText(), scope);
        }
        if (tAndD != null) {
            TypeLookupResult.TypeConfidence confidence = this.checkConfidence(node, tAndD.confidence, tAndD.declaration, tAndD.extraDoc);
            return new TypeLookupResult(tAndD.type, tAndD.declaringType == null ? declaringType : tAndD.declaringType, tAndD.declaration, confidence, scope, tAndD.extraDoc);
        }
        return null;
    }

    protected TypeLookupResult.TypeConfidence checkConfidence(Expression node, TypeLookupResult.TypeConfidence originalConfidence, ASTNode declaration, String extraDoc) {
        return originalConfidence == null ? this.confidence() : originalConfidence;
    }

    protected TypeLookupResult.TypeConfidence confidence() {
        return TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
    }

    public final TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return null;
    }

    public final TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return null;
    }

    public final TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        return null;
    }

    public final TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        return null;
    }

    public final TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        return null;
    }

    public final TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        return null;
    }

    public void lookupInBlock(BlockStatement node, VariableScope scope) {
    }

    protected abstract TypeAndDeclaration lookupTypeAndDeclaration(ClassNode var1, String var2, VariableScope var3);

    public static class TypeAndDeclaration {
        protected final ClassNode type;
        protected final ClassNode declaringType;
        protected final ASTNode declaration;
        protected final String extraDoc;
        protected final TypeLookupResult.TypeConfidence confidence;

        public TypeAndDeclaration(ClassNode type, ASTNode declaration) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = null;
            this.extraDoc = null;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = null;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = extraDoc;
            this.confidence = null;
        }

        public TypeAndDeclaration(ClassNode type, ASTNode declaration, ClassNode declaringType, String extraDoc, TypeLookupResult.TypeConfidence confidence) {
            this.type = type;
            this.declaration = declaration;
            this.declaringType = declaringType;
            this.extraDoc = extraDoc;
            this.confidence = confidence;
        }
    }
}

