/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractCompilerMojo;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;

public class TestCompilerMojo
extends AbstractCompilerMojo {
    private boolean skip;
    private List compileSourceRoots;
    private List classpathElements;
    private File outputDirectory;
    private Set testIncludes = new HashSet();
    private Set testExcludes = new HashSet();
    private File testExcludeFile;
    private File testIncludeFile;

    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        } else {
            super.execute();
        }
    }

    protected List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    protected List getClasspathElements() {
        return this.classpathElements;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        Set effectiveIncludes = this.getEffectiveIncludes();
        Set effectiveExcludes = this.getEffectiveExcludes();
        if (effectiveIncludes.isEmpty() && effectiveExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (effectiveIncludes.isEmpty()) {
                effectiveIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, effectiveIncludes, effectiveExcludes);
        }
        return scanner;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        Set<String> effectiveIncludes = this.getEffectiveIncludes();
        Set effectiveExcludes = this.getEffectiveExcludes();
        if (effectiveIncludes.isEmpty() && effectiveExcludes.isEmpty()) {
            effectiveIncludes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(effectiveIncludes, Collections.EMPTY_SET);
        } else {
            if (effectiveIncludes.isEmpty()) {
                effectiveIncludes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner((Set)effectiveIncludes, effectiveExcludes);
        }
        return scanner;
    }

    protected Set getEffectiveIncludes() {
        HashSet<String> effectiveIncludes = new HashSet<String>(this.testIncludes);
        if (this.testIncludeFile != null) {
            if (!this.testIncludeFile.exists()) {
                throw new IllegalArgumentException("Cannot find: " + this.testIncludeFile);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.testIncludeFile));
                String line = br.readLine();
                while (line != null) {
                    if (line.length() > 0 && !line.startsWith("#")) {
                        this.getLog().debug((CharSequence)("Add include: " + line));
                        effectiveIncludes.add(line);
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot process: " + this.testIncludeFile, ex);
            }
        }
        return effectiveIncludes;
    }

    protected Set getEffectiveExcludes() {
        HashSet<String> effectiveExcludes = new HashSet<String>(this.testExcludes);
        if (this.testExcludeFile != null) {
            if (!this.testExcludeFile.exists()) {
                throw new IllegalArgumentException("Cannot find: " + this.testExcludeFile);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.testExcludeFile));
                String line = br.readLine();
                while (line != null) {
                    if (line.length() > 0 && !line.startsWith("#")) {
                        this.getLog().debug((CharSequence)("Add exclude: " + line));
                        effectiveExcludes.add(line);
                    }
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot process: " + this.testExcludeFile, ex);
            }
        }
        return effectiveExcludes;
    }
}

