/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.http.jetty.Activator;
import org.mortbay.jetty.servlet.OsgiResourceHolder;
import org.mortbay.jetty.servlet.OsgiServletHandler;
import org.mortbay.jetty.servlet.OsgiServletHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.service.http.HttpContext;

public class ServletContextGroup
implements ServletContext {
    private static Map m_contextMap = new HashMap();
    private static Set m_servletSet = new HashSet();
    private OsgiServletHandler m_hdlr = null;
    private HttpContext m_osgiHttpContext = null;
    private Hashtable m_attributes = null;

    static void initializeStatics() {
        m_contextMap.clear();
        m_servletSet.clear();
    }

    static ServletContextGroup getServletContextGroup(OsgiServletHandler hdlr, HttpContext osgiHttpContext) {
        ServletContextGroup grp = (ServletContextGroup)m_contextMap.get(osgiHttpContext);
        if (grp == null) {
            grp = new ServletContextGroup(hdlr, osgiHttpContext);
            m_contextMap.put(osgiHttpContext, grp);
        }
        return grp;
    }

    static boolean isServletRegistered(Servlet servlet) {
        return m_servletSet.contains(servlet);
    }

    private ServletContextGroup(OsgiServletHandler hdlr, HttpContext osgiHttpContext) {
        this.init(hdlr, osgiHttpContext);
    }

    private void init(OsgiServletHandler hdlr, HttpContext osgiHttpContext) {
        this.m_hdlr = hdlr;
        this.m_osgiHttpContext = osgiHttpContext;
        this.m_attributes = new Hashtable();
        m_contextMap.put(this.m_osgiHttpContext, this);
    }

    private void destroy() {
        m_contextMap.remove(this.m_osgiHttpContext);
    }

    public HttpContext getOsgiHttpContext() {
        return this.m_osgiHttpContext;
    }

    void addServlet(Servlet servlet, String alias, Dictionary params) {
        String wAlias = this.aliasWildcard(alias);
        OsgiServletHolder holder = new OsgiServletHolder(this.m_hdlr, servlet, wAlias, this, params);
        this.m_hdlr.addOsgiServletHolder(wAlias, holder);
        Activator.debug(" adding servlet instance: " + servlet);
        m_servletSet.add(servlet);
    }

    void addResource(String alias, String path) {
        String wAlias = this.aliasWildcard(alias);
        OsgiResourceHolder holder = new OsgiResourceHolder(this.m_hdlr, alias, path, this);
        this.m_hdlr.addOsgiServletHolder(wAlias, holder);
        Activator.debug(" adding resources for " + wAlias + " at: " + path);
    }

    void remove(String alias, boolean destroy) {
        String wAlias = this.aliasWildcard(alias);
        ServletHolder holder = this.m_hdlr.removeOsgiServletHolder(wAlias);
        if (holder != null) {
            try {
                Servlet servlet = holder.getServlet();
                if (servlet != null) {
                    Activator.debug(" removing servlet instance: " + servlet);
                    m_servletSet.remove(servlet);
                    if (destroy) {
                        servlet.destroy();
                    }
                    if (m_servletSet.isEmpty()) {
                        this.destroy();
                    }
                }
            }
            catch (ServletException se) {
                // empty catch block
            }
        }
    }

    private String aliasWildcard(String alias) {
        return "/".equals(alias) ? "/*" : alias + "/*";
    }

    public ServletContext getContext(String contextName) {
        return this.m_hdlr.getServletContext().getContext(contextName);
    }

    public int getMajorVersion() {
        return this.m_hdlr.getServletContext().getMajorVersion();
    }

    public int getMinorVersion() {
        return this.m_hdlr.getServletContext().getMinorVersion();
    }

    public String getContextPath() {
        return this.m_hdlr.getServletContext().getContextPath();
    }

    public String getMimeType(String file) {
        String type = this.m_osgiHttpContext.getMimeType(file);
        if (type != null) {
            return type;
        }
        return this.m_hdlr.getServletContext().getMimeType(file);
    }

    public String getRealPath(String path) {
        return null;
    }

    public URL getResource(String path) {
        return this.m_osgiHttpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return this.m_hdlr.getServletContext().getRequestDispatcher(uri);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (this.getMinorVersion() >= 2) {
            return this.m_hdlr.getServletContext().getNamedDispatcher(name);
        }
        return null;
    }

    public String getServerInfo() {
        return this.m_hdlr.getServletContext().getServerInfo();
    }

    public String getServletContextName() {
        if (this.getMinorVersion() >= 3) {
            return this.m_hdlr.getServletContext().getServletContextName();
        }
        return null;
    }

    public Servlet getServlet(String servletName) throws ServletException {
        return this.m_hdlr.getServletContext().getServlet(servletName);
    }

    public Enumeration getServletNames() {
        return this.m_hdlr.getServletContext().getServletNames();
    }

    public String getInitParameter(String name) {
        if (this.getMinorVersion() >= 2) {
            return this.m_hdlr.getServletContext().getInitParameter(name);
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.getMinorVersion() >= 2) {
            return this.m_hdlr.getServletContext().getInitParameterNames();
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getServlets() {
        return this.m_hdlr.getServletContext().getServlets();
    }

    public void log(Exception exception, String message) {
        this.m_hdlr.getServletContext().log(exception, message);
    }

    public void log(String message, Throwable throwable) {
        this.m_hdlr.getServletContext().log(message, throwable);
    }

    public void log(String message) {
        this.m_hdlr.getServletContext().log(message);
    }

    public void setAttribute(String name, Object value) {
        this.m_attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.m_attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.m_attributes.keys();
    }

    public void removeAttribute(String name) {
        this.m_attributes.remove(name);
    }
}

