/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.maven_plugin.common.ClassLoaderSwitcher;
import org.apache.cxf.maven_plugin.wadlto.AbstractCodeGeneratorMojo;
import org.apache.cxf.maven_plugin.wadlto.OptionLoader;
import org.apache.cxf.maven_plugin.wadlto.WadlOption;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="wadl2java", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class WADL2JavaMojo
extends AbstractCodeGeneratorMojo {
    @Parameter
    WadlOption[] wadlOptions;
    @Parameter(property="cxf.wadlRoot", defaultValue="${basedir}/src/main/resources/wadl")
    File wadlRoot;
    @Parameter(property="cxf.testWadlRoot", defaultValue="${basedir}/src/test/resources/wadl")
    File testWadlRoot;
    @Component
    BuildContext buildContext;

    private void mergeOptions(List<WadlOption> effectiveOptions) {
        if (this.wadlOptions == null) {
            return;
        }
        File outputDirFile = this.testSourceRoot == null ? this.sourceRoot : this.testSourceRoot;
        for (WadlOption o : this.wadlOptions) {
            if (this.defaultOptions != null) {
                o.merge(this.defaultOptions);
            }
            if (o.getOutputDir() == null) {
                o.setOutputDir(outputDirFile);
            }
            effectiveOptions.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (JavaUtils.isJava9Compatible()) {
            this.fork = "true";
            this.additionalJvmArgs = "--add-modules java.activation,java.xml.bind,java.xml.ws --add-exports=java.xml.bind/com.sun.xml.internal.bind.v2.runtime=ALL-UNNAMED --add-exports=jdk.xml.dom/org.w3c.dom.html=ALL-UNNAMED --add-exports=java.xml/com.sun.org.apache.xerces.internal.impl.xs=ALL-UNNAMED --add-exports=java.xml.bind/com.sun.xml.internal.bind.marshaller=ALL-UNNAMED --add-opens java.xml.ws/javax.xml.ws.wsaddressing=ALL-UNNAMED --add-opens java.base/java.security=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED " + (this.additionalJvmArgs == null ? "" : this.additionalJvmArgs);
        }
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        this.markerDirectory.mkdirs();
        if (this.project != null && this.sourceRoot != null) {
            this.project.addCompileSourceRoot(this.sourceRoot.getAbsolutePath());
        }
        if (this.project != null && this.testSourceRoot != null) {
            this.project.addTestCompileSourceRoot(this.testSourceRoot.getAbsolutePath());
        }
        if (this.project != null && this.buildContext.isIncremental() && !this.buildContext.hasDelta(this.project.getBasedir())) {
            return;
        }
        List<WadlOption> effectiveWsdlOptions = this.createWadlOptionsFromScansAndExplicitWadlOptions(classesDir);
        if (effectiveWsdlOptions.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to generate");
            return;
        }
        ClassLoaderSwitcher classLoaderSwitcher = new ClassLoaderSwitcher(this.getLog());
        boolean result = true;
        Bus bus = null;
        try {
            Set<URI> cp = classLoaderSwitcher.switchClassLoader(this.project, this.useCompileClasspath, classesDir);
            if ("once".equals(this.fork) || "true".equals(this.fork)) {
                this.forkOnce(cp, effectiveWsdlOptions);
            } else {
                for (WadlOption o : effectiveWsdlOptions) {
                    bus = this.callCodeGenerator(o, bus, cp);
                    File[] dirs = o.getDeleteDirs();
                    if (dirs == null) continue;
                    for (int idx = 0; idx < dirs.length; ++idx) {
                        result = result && this.deleteDir(dirs[idx]);
                    }
                }
            }
        }
        finally {
            if (bus != null) {
                bus.shutdown(true);
            }
            classLoaderSwitcher.restoreClassLoader();
        }
        System.gc();
    }

    private List<WadlOption> createWadlOptionsFromScansAndExplicitWadlOptions(File classesDir) throws MojoExecutionException {
        ArrayList<WadlOption> effectiveOptions = new ArrayList<WadlOption>();
        this.mergeOptions(effectiveOptions);
        this.downloadRemoteDocs(effectiveOptions);
        if (effectiveOptions.isEmpty()) {
            if (this.includes == null) {
                this.includes = new String[]{"*.wadl"};
            }
            File defaultRoot = this.wadlRoot != null && this.wadlRoot.exists() ? this.wadlRoot : this.testWadlRoot;
            effectiveOptions.addAll(OptionLoader.loadWadlOptionsFromFile(defaultRoot, this.includes, this.excludes, this.defaultOptions, classesDir));
        }
        return effectiveOptions;
    }
}

