/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.maven_plugin.common.DocumentArtifact;
import org.apache.cxf.maven_plugin.wadlto.Option;
import org.apache.cxf.maven_plugin.wadlto.WadlOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionLoader {
    private static final String WADL_TYPE = "wadl";
    private static final String WADL_BINDINGS = "-binding-?\\d*.xml$";

    private OptionLoader() {
    }

    public static List<WadlOption> loadWsdlOptionsFromDependencies(MavenProject project, Option defaultOptions, File outputDir) {
        ArrayList<WadlOption> options = new ArrayList<WadlOption>();
        Set dependencies = project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            WadlOption option = OptionLoader.generateWsdlOptionFromArtifact(artifact, outputDir);
            if (option == null) continue;
            if (defaultOptions != null) {
                option.merge(defaultOptions);
            }
            options.add(option);
        }
        return options;
    }

    private static WadlOption generateWsdlOptionFromArtifact(Artifact artifact, File outputDir) {
        if (!WADL_TYPE.equals(artifact.getType())) {
            return null;
        }
        WadlOption option = new WadlOption();
        DocumentArtifact wsdlArtifact = new DocumentArtifact();
        wsdlArtifact.setArtifactId(artifact.getArtifactId());
        wsdlArtifact.setGroupId(artifact.getGroupId());
        wsdlArtifact.setType(artifact.getType());
        wsdlArtifact.setVersion(artifact.getVersion());
        option.setWadlArtifact(wsdlArtifact);
        option.setOutputDir(outputDir);
        return option;
    }

    public static List<WadlOption> loadWsdlOptionsFromFiles(File wsdlBasedir, String[] includes, String[] excludes, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        if (wsdlBasedir == null) {
            return new ArrayList<WadlOption>();
        }
        if (!wsdlBasedir.exists()) {
            throw new MojoExecutionException(wsdlBasedir + " does not exist");
        }
        List<File> wsdlFiles = OptionLoader.getWsdlFiles(wsdlBasedir, includes, excludes);
        ArrayList<WadlOption> wsdlOptions = new ArrayList<WadlOption>();
        for (File wsdl : wsdlFiles) {
            WadlOption wsdlOption = OptionLoader.generateWsdlOptionFromFile(wsdl, defaultOptions, defaultOutputDir);
            if (wsdlOption == null) continue;
            wsdlOptions.add(wsdlOption);
        }
        return wsdlOptions;
    }

    private static String joinWithComma(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        if (arr != null) {
            for (String s : arr) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s);
            }
        }
        return str.toString();
    }

    private static List<File> getWsdlFiles(File dir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList<String> exList = new ArrayList<String>();
        if (excludes != null) {
            exList.addAll(Arrays.asList(excludes));
        }
        exList.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        String inc = OptionLoader.joinWithComma(includes);
        String ex = OptionLoader.joinWithComma(exList.toArray(new String[exList.size()]));
        try {
            List newfiles = FileUtils.getFiles((File)dir, (String)inc, (String)ex);
            return CastUtils.cast((List)newfiles);
        }
        catch (IOException exc) {
            throw new MojoExecutionException(exc.getMessage(), (Exception)exc);
        }
    }

    protected static WadlOption generateWsdlOptionFromFile(File wadl, Option defaultOptions, File defaultOutputDir) throws MojoExecutionException {
        if (wadl == null || !wadl.exists()) {
            return null;
        }
        String wadlFileName = wadl.getName();
        int idx = wadlFileName.toLowerCase().lastIndexOf(".wadl");
        if (idx == -1) {
            idx = wadlFileName.lastIndexOf(46);
        }
        if (idx == -1) {
            return null;
        }
        WadlOption wsdlOption = new WadlOption();
        String wadlName = wadlFileName.substring(0, idx);
        List bindingFiles = org.apache.cxf.helpers.FileUtils.getFiles((File)wadl.getParentFile(), (String)(wadlName + WADL_BINDINGS));
        if (bindingFiles != null) {
            for (File binding : bindingFiles) {
                wsdlOption.addBindingFile(binding);
            }
        }
        wsdlOption.setWadl(wadl.toURI().toString());
        if (wsdlOption.getOutputDir() == null) {
            wsdlOption.setOutputDir(defaultOutputDir);
        }
        return wsdlOption;
    }
}

