/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http_osgi.OsgiDestination;
import org.apache.cxf.transport.http_osgi.OsgiServlet;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transport.servlet.AbstractServletController;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiServletController
extends AbstractServletController {
    private static final Logger LOG = LogUtils.getL7dLogger(OsgiServlet.class);
    private OsgiServlet servlet;

    public OsgiServletController(OsgiServlet servlet) {
        super(servlet.getServletConfig());
        this.servlet = servlet;
    }

    private synchronized void updateDests(HttpServletRequest request) {
        if (this.disableAddressUpdates) {
            return;
        }
        String base = this.forcedBaseAddress == null ? this.getBaseURL(request) : this.forcedBaseAddress;
        Set<String> paths = this.servlet.getTransport().getDestinationsPaths();
        for (String path : paths) {
            OsgiDestination d2 = this.servlet.getTransport().getDestinationForPath(path);
            String ad = d2.getEndpointInfo().getAddress();
            if (!ad.equals(path)) continue;
            d2.getEndpointInfo().setAddress(base + path);
            if (d2.getEndpointInfo().getExtensor(AddressType.class) == null) continue;
            d2.getEndpointInfo().getExtensor(AddressType.class).setLocation(base + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        block17: {
            try {
                ClassLoader orig;
                OsgiDestination d;
                block18: {
                    ClassLoader loader;
                    EndpointInfo ei = new EndpointInfo();
                    String address = request.getPathInfo() == null ? "" : request.getPathInfo();
                    ei.setAddress(address);
                    d = this.servlet.getTransport().getDestinationForPath(ei.getAddress());
                    if (d == null) {
                        if (!this.isHideServiceList && (request.getRequestURI().endsWith(this.serviceListRelativePath) || request.getRequestURI().endsWith(this.serviceListRelativePath + "/")) || StringUtils.isEmpty(request.getPathInfo()) || "/".equals(request.getPathInfo())) {
                            this.updateDests(request);
                            this.generateServiceList(request, res);
                        } else {
                            d = this.checkRestfulRequest(request);
                            if (d == null || d.getMessageObserver() == null) {
                                LOG.warning("Can't find the the request for " + request.getRequestURL() + "'s Observer ");
                                this.generateNotFound(request, res);
                            } else {
                                this.updateDests(request);
                                this.invokeDestination(request, res, d);
                            }
                        }
                        break block17;
                    }
                    ei = d.getEndpointInfo();
                    Bus bus = d.getBus();
                    orig = Thread.currentThread().getContextClassLoader();
                    ResourceManager manager = bus.getExtension(ResourceManager.class);
                    if (manager != null && (loader = manager.resolveResource("", ClassLoader.class)) != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                    if (null != request.getQueryString() && request.getQueryString().length() > 0 && bus.getExtension(QueryHandlerRegistry.class) != null) {
                        String ctxUri = request.getPathInfo();
                        String baseUri = request.getRequestURL().toString() + "?" + request.getQueryString();
                        if ("GET".equals(request.getMethod())) {
                            this.updateDests(request);
                        }
                        for (QueryHandler qh : bus.getExtension(QueryHandlerRegistry.class).getHandlers()) {
                            if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
                            res.setContentType(qh.getResponseContentType(baseUri, ctxUri));
                            ServletOutputStream out = res.getOutputStream();
                            try {
                                qh.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
                                out.flush();
                                return;
                            }
                            catch (Exception e) {
                                LOG.warning(qh.getClass().getName() + " Exception caught writing response: " + e.getMessage());
                                throw new ServletException((Throwable)e);
                            }
                        }
                        break block18;
                    }
                    if (!"/".equals(address) && address.length() != 0) break block18;
                    this.updateDests(request);
                }
                this.invokeDestination(request, res, d);
                break block17;
                finally {
                    Thread.currentThread().setContextClassLoader(orig);
                }
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private OsgiDestination checkRestfulRequest(HttpServletRequest request) throws IOException {
        String address = request.getPathInfo() == null ? "" : request.getPathInfo();
        for (String path : this.servlet.getTransport().getDestinationsPaths()) {
            if (!address.startsWith(path)) continue;
            return this.servlet.getTransport().getDestinationForPath(path);
        }
        return null;
    }

    protected void generateServiceList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        response.getWriter().write("<HTML><HEAD>");
        if (this.serviceListStyleSheet != null) {
            response.getWriter().write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + request.getContextPath() + "/" + this.serviceListStyleSheet + "\">");
        } else {
            response.getWriter().write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + request.getRequestURI() + "/?stylesheet=1\">");
        }
        response.getWriter().write("<meta http-equiv=content-type content=\"text/html; charset=UTF-8\">");
        response.getWriter().write("<title>CXF - Service list</title>");
        response.getWriter().write("</head><body>");
        Collection<OsgiDestination> destinations = this.servlet.getTransport().getDestinations();
        if (destinations.size() > 0) {
            this.writeSOAPEndpoints(response, destinations);
            this.writeRESTfulEndpoints(response, destinations);
        } else {
            response.getWriter().write("<span class=\"heading\">No services have been found.</span>");
        }
        response.getWriter().write("</body></html>");
    }

    private void writeSOAPEndpoints(HttpServletResponse response, Collection<OsgiDestination> destinations) throws IOException {
        response.getWriter().write("<span class=\"heading\">Available SOAP services:</span><br/>");
        response.getWriter().write("<table " + (this.serviceListStyleSheet == null ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (OsgiDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getName() || null == sd.getEndpointInfo().getInterface()) continue;
            response.getWriter().write("<tr><td>");
            response.getWriter().write("<span class=\"porttypename\">" + sd.getEndpointInfo().getInterface().getName().getLocalPart() + "</span>");
            response.getWriter().write("<ul>");
            for (OperationInfo oi : sd.getEndpointInfo().getInterface().getOperations()) {
                response.getWriter().write("<li>" + oi.getName().getLocalPart() + "</li>");
            }
            response.getWriter().write("</ul>");
            response.getWriter().write("</td><td>");
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
            response.getWriter().write("<br/><span class=\"field\">WSDL :</span> <a href=\"" + address + "?wsdl\">" + sd.getEndpointInfo().getService().getName() + "</a>");
            response.getWriter().write("<br/><span class=\"field\">Target namespace:</span> <span class=\"value\">" + sd.getEndpointInfo().getService().getTargetNamespace() + "</span>");
            response.getWriter().write("</td></tr>");
        }
        response.getWriter().write("</table><br/><br/>");
    }

    private void writeRESTfulEndpoints(HttpServletResponse response, Collection<OsgiDestination> destinations) throws IOException {
        ArrayList<OsgiDestination> restfulDests = new ArrayList<OsgiDestination>();
        for (OsgiDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface()) continue;
            restfulDests.add(sd);
        }
        if (restfulDests.size() == 0) {
            return;
        }
        response.getWriter().write("<span class=\"heading\">Available RESTful services:</span><br/>");
        response.getWriter().write("<table " + (this.serviceListStyleSheet == null ? "cellpadding=\"1\" cellspacing=\"1\" border=\"1\" width=\"100%\"" : "") + ">");
        for (OsgiDestination sd : destinations) {
            if (null != sd.getEndpointInfo().getInterface()) continue;
            response.getWriter().write("<tr><td>");
            String address = sd.getEndpointInfo().getAddress();
            response.getWriter().write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
            response.getWriter().write("<br/><span class=\"field\">WADL :</span> <a href=\"" + address + "?_wadl&_type=xml\">" + address + "?_wadl&type=xml" + "</a>");
            response.getWriter().write("</td></tr>");
        }
        response.getWriter().write("</table>");
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }

    public void invokeDestination(final HttpServletRequest request, HttpServletResponse response, OsgiDestination d) throws ServletException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        try {
            String normalizedEncoding;
            MessageImpl inMessage = this.servlet.createInMessage();
            inMessage.setContent(InputStream.class, request.getInputStream());
            inMessage.put("HTTP.REQUEST", request);
            inMessage.put("HTTP.RESPONSE", response);
            inMessage.put("HTTP.CONTEXT", this.servlet.getServletContext());
            inMessage.put("HTTP.CONFIG", this.servlet.getServletConfig());
            inMessage.put("org.apache.cxf.request.method", request.getMethod());
            inMessage.put("org.apache.cxf.request.uri", request.getRequestURI());
            inMessage.put(Message.PATH_INFO, request.getPathInfo());
            inMessage.put(Message.QUERY_STRING, request.getQueryString());
            inMessage.put("Content-Type", request.getContentType());
            inMessage.put("Accept", request.getHeader("Accept"));
            inMessage.put(Message.BASE_PATH, d.getAddress().getAddress().getValue());
            inMessage.put(SecurityContext.class, new SecurityContext(){

                public Principal getUserPrincipal() {
                    return request.getUserPrincipal();
                }

                public boolean isUserInRole(String role) {
                    return request.isUserInRole(role);
                }
            });
            String enc = request.getCharacterEncoding();
            if (enc != null && enc.endsWith("\"")) {
                enc = enc.substring(0, enc.length() - 1);
            }
            if ((normalizedEncoding = HttpHeaderHelper.mapCharset(enc)) == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, enc).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put(Message.ENCODING, normalizedEncoding);
            SSLUtils.propogateSecureSession(request, inMessage);
            ExchangeImpl exchange = this.servlet.createExchange();
            exchange.setInMessage(inMessage);
            exchange.setSession(new HTTPSession(request));
            d.doMessage(inMessage);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

