/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.impl.SAMLObjectContentReference;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataTool {
    private static Logger log = Logger.getLogger(MetadataTool.class);
    private static ParserPool parser;

    public static void main(String[] args) throws Exception {
        KeyStore keystore;
        DefaultBootstrap.bootstrap();
        MetadataTool.configureLogging();
        CmdLineParser parser = CLIParserBuilder.buildParser();
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            MetadataTool.errorAndExit(e.getMessage(), (Exception)((Object)e));
        }
        Boolean helpEnabled = (Boolean)parser.getOptionValue(CLIParserBuilder.HELP_ARG);
        if (helpEnabled != null) {
            MetadataTool.printHelp(System.out);
            System.out.flush();
            System.exit(0);
        }
        Boolean verify = (Boolean)parser.getOptionValue(CLIParserBuilder.VALIDATE_ARG);
        String inputFile = (String)parser.getOptionValue(CLIParserBuilder.INPUT_FILE_ARG);
        SignableSAMLObject metadata = (SignableSAMLObject)MetadataTool.fetchMetadata(inputFile, verify);
        String keystorePath = (String)parser.getOptionValue(CLIParserBuilder.KEYSTORE_ARG);
        String storeType = (String)parser.getOptionValue(CLIParserBuilder.KEYSTORE_TYPE_ARG);
        String storePass = (String)parser.getOptionValue(CLIParserBuilder.KEYSTORE_PASS_ARG);
        String alias = (String)parser.getOptionValue(CLIParserBuilder.ALIAS_ARG);
        String keyPass = (String)parser.getOptionValue(CLIParserBuilder.KEY_PASS_ARG);
        Boolean sign = (Boolean)parser.getOptionValue(CLIParserBuilder.SIGN_ARG);
        if (sign != null && sign.booleanValue()) {
            keystore = MetadataTool.getKeyStore(keystorePath, storeType, storePass);
            Credential signingCredential = MetadataTool.getSigningCredential(keystore, alias, keyPass);
            MetadataTool.sign(metadata, signingCredential);
        } else if (keystorePath != null) {
            keystore = MetadataTool.getKeyStore(keystorePath, storeType, storePass);
            Credential verificationCredential = MetadataTool.getVerificationCredential(keystore, alias);
            MetadataTool.verifySignature(metadata, verificationCredential);
        }
        String outputFile = (String)parser.getOptionValue(CLIParserBuilder.OUTPUT_FILE_ARG);
        MetadataTool.printMetadata((XMLObject)metadata, outputFile);
    }

    private static XMLObject fetchMetadata(String inputFile, Boolean validate) {
        if (DatatypeHelper.isEmpty((String)inputFile)) {
            MetadataTool.errorAndExit("No input file was specified.", null);
        }
        try {
            log.debug((Object)("Fetching metadata from input " + inputFile));
            URL inputURL = new URL(inputFile);
            Document metadatDocument = parser.parse(inputURL.openStream());
            Element metadataRoot = metadatDocument.getDocumentElement();
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(metadataRoot);
            return unmarshaller.unmarshall(metadataRoot);
        }
        catch (MalformedURLException e) {
            MetadataTool.errorAndExit("Input file/url was not properly formed", e);
        }
        catch (XMLParserException e) {
            MetadataTool.errorAndExit("Unable to parse and validate metadata document", (Exception)((Object)e));
        }
        catch (IOException e) {
            MetadataTool.errorAndExit("Unable to read input file/url", e);
        }
        catch (UnmarshallingException e) {
            MetadataTool.errorAndExit("Unable to unmarshall metadata", (Exception)((Object)e));
        }
        return null;
    }

    private static KeyStore getKeyStore(String keyStore, String storeType, String storePass) {
        try {
            FileInputStream keyStoreIn = new FileInputStream(keyStore);
            KeyStore ks = KeyStore.getInstance(storeType);
            storePass = DatatypeHelper.safeTrimOrNullString((String)storePass);
            if (storePass != null) {
                ks.load(keyStoreIn, storePass.toCharArray());
                return ks;
            }
            log.error((Object)"No password provided for keystore");
            System.exit(1);
        }
        catch (Exception e) {
            log.error((Object)("Unable to load keystore from file " + keyStore), (Throwable)e);
            System.exit(1);
        }
        return null;
    }

    private static Credential getSigningCredential(KeyStore keystore, String alias, String keyPass) {
        if ((alias = DatatypeHelper.safeTrimOrNullString((String)alias)) == null) {
            log.error((Object)"Key alias may not be null or empty");
            System.exit(1);
        }
        if ((keyPass = DatatypeHelper.safeTrimOrNullString((String)keyPass)) == null) {
            log.error((Object)"Private key password may not be null or empty");
            System.exit(1);
        }
        KeyStore.PasswordProtection keyPassParam = new KeyStore.PasswordProtection(keyPass.toCharArray());
        try {
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(alias, keyPassParam);
            return SecurityHelper.getSimpleCredential((PublicKey)pkEntry.getCertificate().getPublicKey(), (PrivateKey)pkEntry.getPrivateKey());
        }
        catch (Exception e) {
            log.error((Object)("Unable to retrieve private key " + alias), (Throwable)e);
            return null;
        }
    }

    private static Credential getVerificationCredential(KeyStore keystore, String alias) {
        if ((alias = DatatypeHelper.safeTrimOrNullString((String)alias)) == null) {
            log.error((Object)"Key alias may not be null or empty");
            System.exit(1);
        }
        try {
            Certificate cert = keystore.getCertificate(alias);
            return SecurityHelper.getSimpleCredential((PublicKey)cert.getPublicKey(), null);
        }
        catch (Exception e) {
            log.error((Object)("Unable to retrieve certificate " + alias), (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    private static void sign(SignableSAMLObject metadata, Credential signingCredential) {
        XMLObjectBuilder sigBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        Signature signature = (Signature)sigBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        SAMLObjectContentReference contentRef = new SAMLObjectContentReference(metadata);
        signature.getContentReferences().add(contentRef);
        signature.setSigningCredential(signingCredential);
        metadata.setSignature(signature);
        Signer.signObject((Signature)signature);
    }

    private static void verifySignature(SignableSAMLObject metadata, Credential verificationCredential) {
    }

    private static void printMetadata(XMLObject metadata, String outputFile) {
        PrintStream out = System.out;
        if (outputFile != null) {
            try {
                out = new PrintStream(new File(outputFile));
            }
            catch (Exception e) {
                MetadataTool.errorAndExit("Unable to open output file for writing", e);
            }
        }
        try {
            if (!DatatypeHelper.isEmpty((String)outputFile)) {
                File outFile = new File(outputFile);
                outFile.createNewFile();
                out = new PrintStream(new File(outputFile));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to write to output file", (Throwable)e);
        }
        out.print(XMLHelper.nodeToString((Node)metadata.getDOM()));
    }

    private static void configureLogging() {
        ConsoleAppender console = new ConsoleAppender();
        console.setWriter((Writer)new PrintWriter(System.err));
        console.setName("stderr");
        console.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n"));
        log = Logger.getLogger((String)"org.opensaml");
        log.addAppender((Appender)console);
        log.setLevel(Level.ERROR);
        Logger.getRootLogger().setLevel(Level.OFF);
    }

    private static void printHelp(PrintStream out) {
        out.println("usage: java org.opensaml.security.MetadataTool");
        out.println();
        out.println("when retrieving:");
        out.println("  --input <fileOrUrl> [--ouput <outfile>]");
        out.println("when signing:");
        out.println("  --input <fileOrUrl> --sign --keystore <keystore> [--storetype <storetype>] --storepass <password> --alias <alias> [--keypass <password>] [--output <outfile>]");
        out.println("when retrieving and verifying signature:");
        out.println("  --input <fileOrUrl> --validate --keystore <keystore> [--storetype <storetype>] --storepass <password> --alias <alias> [--output <outfile>]");
        out.println();
        out.println();
        out.println(String.format("  --%-16s %s", "help", "print this message"));
        out.println(String.format("  --%-16s %s", "validate", "validate the digital signature on the metadata if it is signed"));
        out.println(String.format("  --%-16s %s", "sign", "sign the input file and write out a signed version"));
        out.println(String.format("  --%-16s %s", "input", "filesystem path or URL to fetch metadata from"));
        out.println(String.format("  --%-16s %s", "keystore", "filesystem path to Java keystore"));
        out.println(String.format("  --%-16s %s", "storetype", "the keystore type (default: JKS)"));
        out.println(String.format("  --%-16s %s", "storepass", "keystore password"));
        out.println(String.format("  --%-16s %s", "alias", "alias of signing or verification key"));
        out.println(String.format("  --%-16s %s", "keypass", "private key password"));
        out.println(String.format("  --%-16s %s", "output", "filesystem path where metadata will be written"));
        out.println();
    }

    private static void errorAndExit(String errorMessage, Exception e) {
        if (e == null) {
            log.error((Object)errorMessage);
        } else {
            log.error((Object)errorMessage, (Throwable)e);
        }
        MetadataTool.printHelp(System.out);
        System.out.flush();
        System.exit(1);
    }

    private static class CLIParserBuilder {
        public static final String HELP = "help";
        public static final String SIGN = "sign";
        public static final String VALIDATE = "validate";
        public static final String INPUT_FILE = "input";
        public static final String KEYSTORE = "keystore";
        public static final String KEYSTORE_TYPE = "storetype";
        public static final String KEYSTORE_PASS = "storepass";
        public static final String ALIAS = "alias";
        public static final String KEY_PASS = "keypass";
        public static final String OUTPUT_FILE = "output";
        public static CmdLineParser.Option HELP_ARG;
        public static CmdLineParser.Option SIGN_ARG;
        public static CmdLineParser.Option VALIDATE_ARG;
        public static CmdLineParser.Option INPUT_FILE_ARG;
        public static CmdLineParser.Option KEYSTORE_ARG;
        public static CmdLineParser.Option KEYSTORE_TYPE_ARG;
        public static CmdLineParser.Option KEYSTORE_PASS_ARG;
        public static CmdLineParser.Option ALIAS_ARG;
        public static CmdLineParser.Option KEY_PASS_ARG;
        public static CmdLineParser.Option OUTPUT_FILE_ARG;

        private CLIParserBuilder() {
        }

        public static CmdLineParser buildParser() {
            CmdLineParser parser = new CmdLineParser();
            HELP_ARG = parser.addBooleanOption(HELP);
            SIGN_ARG = parser.addBooleanOption(SIGN);
            VALIDATE_ARG = parser.addBooleanOption(VALIDATE);
            INPUT_FILE_ARG = parser.addStringOption(INPUT_FILE);
            KEYSTORE_ARG = parser.addStringOption(KEYSTORE);
            KEYSTORE_TYPE_ARG = parser.addStringOption(KEYSTORE_TYPE);
            KEYSTORE_PASS_ARG = parser.addStringOption(KEYSTORE_PASS);
            ALIAS_ARG = parser.addStringOption(ALIAS);
            KEY_PASS_ARG = parser.addStringOption(KEY_PASS);
            OUTPUT_FILE_ARG = parser.addStringOption(OUTPUT_FILE);
            return parser;
        }
    }
}

