/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import org.apache.log4j.Logger;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Element;

public class DOMMetadataProvider
extends AbstractObservableMetadataProvider
implements MetadataProvider {
    private final Logger log = Logger.getLogger(DOMMetadataProvider.class);
    private boolean initialized = false;
    private Element metadataElement;
    private XMLObject metadata;

    public DOMMetadataProvider(Element mdElement) {
        this.metadataElement = mdElement;
    }

    public XMLObject getMetadata() {
        return this.metadata;
    }

    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        super.setMetadataFilter(newFilter);
        this.refreshMetadata();
    }

    public synchronized void initialize() throws MetadataProviderException {
        if (!this.initialized) {
            this.refreshMetadata();
            this.initialized = true;
        }
    }

    private synchronized void refreshMetadata() throws MetadataProviderException {
        try {
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(this.metadataElement);
            this.metadata = unmarshaller.unmarshall(this.metadataElement);
            this.metadata.releaseDOM();
            this.metadata.releaseChildrenDOM(true);
            this.filterMetadata(this.metadata);
            this.emitChangeEvent();
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata element";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }
}

