/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import org.apache.log4j.Logger;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;

public class EntitiesDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    private static Logger log = Logger.getLogger(EntitiesDescriptorMarshaller.class);

    public EntitiesDescriptorMarshaller() {
        super("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor");
    }

    protected EntitiesDescriptorMarshaller(String namespaceURI, String elementLocalName) {
        super(namespaceURI, elementLocalName);
    }

    public void marshallAttributes(XMLObject samlElement, Element domElement) {
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)samlElement;
        if (entitiesDescriptor.getID() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writing ID attribute to EntitiesDescriptor DOM element.");
            }
            domElement.setAttributeNS(null, "ID", entitiesDescriptor.getID());
            domElement.setIdAttributeNS(null, "ID", true);
        }
        if (entitiesDescriptor.getValidUntil() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting validUntil attribute to EntitiesDescriptor DOM element");
            }
            String validUntilStr = ISODateTimeFormat.dateTime().print((ReadableInstant)entitiesDescriptor.getValidUntil());
            domElement.setAttributeNS(null, "validUntil", validUntilStr);
        }
        if (entitiesDescriptor.getCacheDuration() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting cacheDuration attribute to EntitiesDescriptor DOM element");
            }
            String cacheDuration = XMLHelper.longToDuration((long)entitiesDescriptor.getCacheDuration());
            domElement.setAttributeNS(null, "cacheDuration", cacheDuration);
        }
        if (entitiesDescriptor.getName() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting Name attribute to EntitiesDescriptor DOM element");
            }
            domElement.setAttributeNS(null, "Name", entitiesDescriptor.getName());
        }
    }
}

