/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.encryption;

import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.EncryptedElementType;
import org.opensaml.saml2.core.EncryptedID;
import org.opensaml.saml2.core.NewEncryptedID;
import org.opensaml.saml2.core.NewID;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;

public class Decrypter
extends org.opensaml.xml.encryption.Decrypter {
    private Logger log = Logger.getLogger(Decrypter.class);
    private boolean rootInNewDocument = false;

    public Decrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        super(newResolver, newKEKResolver, newEncKeyResolver);
    }

    public boolean isRootInNewDocument() {
        return this.rootInNewDocument;
    }

    public void setRootInNewDocument(boolean flag) {
        this.rootInNewDocument = flag;
    }

    public Assertion decrypt(EncryptedAssertion encryptedAssertion) throws DecryptionException {
        SAMLObject samlObject = this.decryptData(encryptedAssertion);
        if (!(samlObject instanceof Assertion)) {
            throw new DecryptionException("Decrypted SAMLObject was not an instance of Assertion");
        }
        return (Assertion)samlObject;
    }

    public Attribute decrypt(EncryptedAttribute encryptedAttribute) throws DecryptionException {
        SAMLObject samlObject = this.decryptData(encryptedAttribute);
        if (!(samlObject instanceof Attribute)) {
            throw new DecryptionException("Decrypted SAMLObject was not an instance of Attribute");
        }
        return (Attribute)samlObject;
    }

    public SAMLObject decrypt(EncryptedID encryptedID) throws DecryptionException {
        return this.decryptData(encryptedID);
    }

    public NewID decrypt(NewEncryptedID newEncryptedID) throws DecryptionException {
        SAMLObject samlObject = this.decryptData(newEncryptedID);
        if (!(samlObject instanceof NewID)) {
            throw new DecryptionException("Decrypted SAMLObject was not an instance of NewID");
        }
        return (NewID)samlObject;
    }

    private SAMLObject decryptData(EncryptedElementType encElement) throws DecryptionException {
        if (encElement.getEncryptedData() == null) {
            throw new DecryptionException("Element had no EncryptedData child");
        }
        XMLObject xmlObject = null;
        try {
            xmlObject = this.decryptData(encElement.getEncryptedData(), this.rootInNewDocument);
        }
        catch (DecryptionException e) {
            this.log.error((Object)"SAML Decrypter encountered an error decrypting element content", (Throwable)e);
            throw e;
        }
        if (!(xmlObject instanceof SAMLObject)) {
            throw new DecryptionException("Decrypted XMLObject was not an instance of SAMLObject");
        }
        return (SAMLObject)xmlObject;
    }
}

