/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class RequestedAuthnContextUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    public RequestedAuthnContextUnmarshaller() {
        super("urn:oasis:names:tc:SAML:2.0:protocol", "RequestedAuthnContext");
    }

    protected RequestedAuthnContextUnmarshaller(String namespaceURI, String elementLocalName) {
        super(namespaceURI, elementLocalName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        RequestedAuthnContext rac = (RequestedAuthnContext)samlObject;
        if (attribute.getLocalName().equals("Comparison")) {
            if ("exact".equals(attribute.getValue())) {
                rac.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
                return;
            } else if ("minimum".equals(attribute.getValue())) {
                rac.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
                return;
            } else if ("maximum".equals(attribute.getValue())) {
                rac.setComparison(AuthnContextComparisonTypeEnumeration.MAXIMUM);
                return;
            } else {
                if (!"better".equals(attribute.getValue())) throw new UnmarshallingException("Saw an invalid value for Comparison attribute: " + attribute.getValue());
                rac.setComparison(AuthnContextComparisonTypeEnumeration.BETTER);
            }
            return;
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }

    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        RequestedAuthnContext rac = (RequestedAuthnContext)parentSAMLObject;
        if (childSAMLObject instanceof AuthnContextClassRef) {
            rac.getAuthnContextClassRefs().add((AuthnContextClassRef)childSAMLObject);
        } else if (childSAMLObject instanceof AuthnContextDeclRef) {
            rac.getAuthnContextDeclRefs().add((AuthnContextDeclRef)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }
}

