/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.common;

import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.saml2.common.CacheableSAMLObject;
import org.opensaml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.xml.XMLObject;

public class SAML2Helper {
    public static boolean isValid(XMLObject xmlObject) {
        TimeBoundSAMLObject timeBoundObject;
        if (xmlObject instanceof TimeBoundSAMLObject && !(timeBoundObject = (TimeBoundSAMLObject)xmlObject).isValid()) {
            return false;
        }
        for (XMLObject child : xmlObject.getOrderedChildren()) {
            if (SAML2Helper.isValid(child)) continue;
            return false;
        }
        return true;
    }

    public static DateTime getEarliestExpiration(XMLObject xmlObject) {
        DateTime now = new DateTime();
        return SAML2Helper.getEarliestExpiration(xmlObject, now, now);
    }

    public static DateTime getEarliestExpiration(XMLObject xmlObject, DateTime earliestExpiration, DateTime now) {
        List children;
        TimeBoundSAMLObject timeBoundObject;
        DateTime elementExpirationTime;
        CacheableSAMLObject cacheInfo;
        DateTime expirationTime = earliestExpiration;
        if (xmlObject instanceof CacheableSAMLObject && (cacheInfo = (CacheableSAMLObject)xmlObject).getCacheDuration() != null && cacheInfo.getCacheDuration() > 0L && (elementExpirationTime = now.plus(cacheInfo.getCacheDuration().longValue())).isBefore((ReadableInstant)expirationTime)) {
            expirationTime = elementExpirationTime;
        }
        if (xmlObject instanceof TimeBoundSAMLObject && (elementExpirationTime = (timeBoundObject = (TimeBoundSAMLObject)xmlObject).getValidUntil()) != null && elementExpirationTime.isBefore((ReadableInstant)earliestExpiration)) {
            earliestExpiration = elementExpirationTime;
        }
        if ((children = xmlObject.getOrderedChildren()) != null) {
            for (XMLObject child : xmlObject.getOrderedChildren()) {
                if (child == null) continue;
                earliestExpiration = SAML2Helper.getEarliestExpiration(child, earliestExpiration, now);
            }
        }
        return earliestExpiration;
    }
}

