/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.common.binding.BindingException;
import org.opensaml.saml2.binding.encoding.AbstractSAML2HTTPMessageEncoder;
import org.opensaml.saml2.core.RequestAbstractType;

public class HTTPPostEncoder
extends AbstractSAML2HTTPMessageEncoder {
    public static final String BINDING_URI = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private final Logger log = Logger.getLogger(HTTPPostEncoder.class);
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;

    public String getBindingURI() {
        return BINDING_URI;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(String id) {
        this.velocityTemplateId = id;
    }

    public void encode() throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Beginning SAML 2 HTTP POST encoding");
        }
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        this.signMessage();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Base64 encoding message");
        }
        String encodedMessage = this.getBase64EncodedMessage();
        try {
            this.initializeResponse();
            response.setContentType("application/xhtml+xml");
            this.postEncode(response.getWriter(), encodedMessage);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to access HttpServletResponse output writer", (Throwable)e);
            throw new BindingException("Unable to access HttpServletResponse output writer", e);
        }
    }

    protected void postEncode(Writer responseWriter, String message) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating velocity context");
        }
        VelocityContext context = new VelocityContext();
        context.put("action", (Object)this.getEndpointURL());
        if (this.getSamlMessage() instanceof RequestAbstractType) {
            context.put("SAMLRequest", (Object)message);
        } else {
            context.put("SAMLResponse", (Object)message);
        }
        if (this.checkRelayState()) {
            context.put("RelayState", (Object)this.getRelayState());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Invoking velocity template");
        }
        try {
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, responseWriter);
        }
        catch (Exception e) {
            this.log.error((Object)"Error invoking velocity template", (Throwable)e);
            throw new BindingException("Error creating output document", e);
        }
    }
}

