/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.decoding.impl.AbstractHTTPMessageDecoder;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;

public class HTTPRedirectDeflateDecoder
extends AbstractHTTPMessageDecoder {
    public static final String BINDING_URI = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    private static Logger log = Logger.getLogger(HTTPRedirectDeflateDecoder.class);
    private boolean isSigned;
    private String signatureAlgorithm;

    public String getBindingURI() {
        return BINDING_URI;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void decode() throws BindingException, SecurityPolicyException {
        InputStream samlMessageIns;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning SAML 2 HTTP Redirect decoding");
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        this.setHttpMethod("GET");
        this.setRelayState(request.getParameter("RelayState"));
        if (request.getParameter("SAMLRequest") != null) {
            samlMessageIns = this.decodeMessage(request.getParameter("SAMLRequest"));
        } else if (request.getParameter("SAMLResponse") != null) {
            samlMessageIns = this.decodeMessage(request.getParameter("SAMLResponse"));
        } else {
            throw new BindingException("No SAMLRequest or SAMLResponse query path parameter, invalid SAML 2 HTTP Redirect message");
        }
        SAMLObject samlMessage = (SAMLObject)this.unmarshallMessage(samlMessageIns);
        this.setSAMLMessage(samlMessage);
        if (request.getParameter("Signature") != null) {
            this.isSigned = true;
            this.signatureAlgorithm = request.getParameter("SigAlg");
        }
        this.evaluateSecurityPolicy((XMLObject)samlMessage);
    }

    protected InputStream decodeMessage(String message) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Base64 decoding and inflating SAML message");
        }
        try {
            ByteArrayInputStream encodedMessage = new ByteArrayInputStream(message.getBytes());
            Base64.InputStream base64In = new Base64.InputStream((InputStream)encodedMessage);
            InflaterInputStream inflater = new InflaterInputStream((InputStream)base64In, new Inflater(true));
            return inflater;
        }
        catch (Exception e) {
            log.error((Object)"Unable to Base64 decode and inflate SAML message", (Throwable)e);
            throw new BindingException("Unable to Base64 decode and inflate SAML message", e);
        }
    }
}

