/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.artifact.SAMLArtifact;
import org.opensaml.common.binding.artifact.SAMLArtifactFactory;
import org.opensaml.common.binding.decoding.impl.AbstractHTTPMessageDecoder;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

public class HTTPArtifactDecoder
extends AbstractHTTPMessageDecoder {
    private static Logger log = Logger.getLogger(HTTPArtifactDecoder.class);
    private SAMLArtifactFactory artifactFactory;
    private SAMLArtifact artifact;

    public String getBindingURI() {
        return null;
    }

    public SAMLArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(SAMLArtifactFactory factory) {
        this.artifactFactory = factory;
    }

    public SAMLArtifact getArtifact() {
        return this.artifact;
    }

    public void decode() throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning SAML 2 HTTP Artifact decoding");
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        if (this.getSecurityPolicy() != null) {
            try {
                this.getSecurityPolicy().evaluate((ServletRequest)this.getRequest(), null);
            }
            catch (SecurityPolicyException e) {
                throw new BindingException("Security policy evaluation failed while decoding HTTP artifact message", (Exception)((Object)e));
            }
        }
        this.setHttpMethod(request.getMethod());
        if (!DatatypeHelper.isEmpty((String)request.getParameter("RelayState"))) {
            this.setRelayState(request.getParameter("RelayState"));
        }
        this.artifact = this.decodeArtifact();
    }

    protected SAMLArtifact decodeArtifact() throws BindingException {
        String samlArt;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Decoding SAML artifact");
        }
        if (DatatypeHelper.isEmpty((String)(samlArt = ((HttpServletRequest)this.getRequest()).getParameter("SAMLArt")))) {
            log.error((Object)"Request does not contain a SAML artifact");
            throw new BindingException("Request does not contain a SAML artifact");
        }
        byte[] artifactBytes = Base64.decode((String)samlArt);
        return this.getArtifactFactory().buildArtifact(SAMLVersion.VERSION_20, artifactBytes);
    }
}

