/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IndexedEndpoint;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthnResponseEndpointSelector
extends BasicEndpointSelector {
    @Override
    public Endpoint selectEndpoint() {
        List<Endpoint> endpoints = this.getRelyingPartyRole().getEndpoints(this.getEndpointType());
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint endpoint = null;
        if (this.getSamlRequest() != null) {
            AuthnRequest request = (AuthnRequest)this.getSamlRequest();
            if (request.getAssertionConsumerServiceIndex() != null) {
                endpoint = this.selectEndpointByACSIndex(request, endpoints);
            } else if (request.getAssertionConsumerServiceURL() != null) {
                endpoint = this.selectEndpointByACSURL(request, endpoints);
            }
        }
        if (endpoint == null) {
            endpoint = endpoints.get(0) instanceof IndexedEndpoint ? this.selectIndexedEndpoint(endpoints) : this.selectNonIndexedEndpoint(endpoints);
        }
        return endpoint;
    }

    protected Endpoint selectEndpointByACSIndex(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        Integer acsIndex = request.getAssertionConsumerServiceIndex();
        for (IndexedEndpoint endpoint : endpoints) {
            if (endpoint.getIndex() == null || !endpoint.getIndex().equals(acsIndex)) continue;
            return endpoint;
        }
        return null;
    }

    protected Endpoint selectEndpointByACSURL(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        try {
            URL acsURL = new URL(request.getAssertionConsumerServiceURL());
            String acsBinding = DatatypeHelper.safeTrimOrNullString((String)request.getProtocolBinding());
            for (IndexedEndpoint endpoint : endpoints) {
                String endpointBinding = DatatypeHelper.safeTrimOrNullString((String)endpoint.getBinding());
                if ((acsBinding == null || !acsBinding.equals(endpointBinding) || !this.getSupportedIssuerBindings().contains(endpointBinding)) && !this.getSupportedIssuerBindings().contains(endpointBinding)) continue;
                URL endpointURL = new URL(endpoint.getLocation());
                if (endpointURL.equals(acsURL)) {
                    return endpoint;
                }
                endpointURL = new URL(endpoint.getResponseLocation());
                if (!endpointURL.equals(acsURL)) continue;
                return endpoint;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

