/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.ContentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLObjectContentReference
implements ContentReference {
    private static Logger log = Logger.getLogger(SAMLObjectContentReference.class);
    private SignableSAMLObject signableObject;
    private String digestAlgorithm;
    private List<String> transforms;

    public SAMLObjectContentReference(SignableSAMLObject newSignableObject) {
        this.signableObject = newSignableObject;
        this.transforms = new ArrayList<String>();
        this.digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
        this.transforms.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        this.transforms.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
    }

    public List<String> getTransforms() {
        return this.transforms;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String newAlgorithm) {
        this.digestAlgorithm = newAlgorithm;
    }

    public void createReference(XMLSignature signature) {
        try {
            Transforms dsigTransforms = new Transforms(signature.getDocument());
            for (int i = 0; i < this.transforms.size(); ++i) {
                String transform = this.transforms.get(i);
                dsigTransforms.addTransform(transform);
                if (!transform.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") && !transform.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
                this.processExclusiveTransform(signature, dsigTransforms.item(i));
            }
            signature.addDocument("#" + this.signableObject.getSignatureReferenceID(), dsigTransforms, this.digestAlgorithm);
        }
        catch (TransformationException e) {
            log.error((Object)"Unsupported signature transformation", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            log.error((Object)"Error adding content reference to signature", (Throwable)e);
        }
    }

    private void processExclusiveTransform(XMLSignature signature, Transform transform) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding list of inclusive namespaces for signature exclusive canonicalization transform");
        }
        HashSet<String> inclusiveNamespacePrefixes = new HashSet<String>();
        this.populateNamespacePrefixes(inclusiveNamespacePrefixes, (XMLObject)this.signableObject);
        if (inclusiveNamespacePrefixes != null && inclusiveNamespacePrefixes.size() > 0) {
            InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(signature.getDocument(), inclusiveNamespacePrefixes);
            transform.getElement().appendChild(inclusiveNamespaces.getElement());
        }
    }

    private void populateNamespacePrefixes(Set<String> namespacePrefixes, XMLObject signatureContent) {
        if (signatureContent.getNamespaces() != null) {
            for (Namespace namespace : signatureContent.getNamespaces()) {
                if (namespace == null) continue;
                namespacePrefixes.add(namespace.getNamespacePrefix());
            }
        }
        if (signatureContent.getOrderedChildren() != null) {
            for (XMLObject xmlObject : signatureContent.getOrderedChildren()) {
                if (xmlObject == null) continue;
                this.populateNamespacePrefixes(namespacePrefixes, xmlObject);
            }
        }
    }
}

