/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLSecurityPolicy
extends BasicSecurityPolicy<ServletRequest> {
    private final Logger log = Logger.getLogger(SAMLSecurityPolicy.class);
    private MetadataProvider metadataProvider;
    private QName issuerRole;
    private String issuerProtocol;
    private RoleDescriptor issuerRoleMetadata;

    public SAMLSecurityPolicy(QName role, String protocol) {
        super(true);
        this.issuerRole = role;
        this.issuerProtocol = DatatypeHelper.safeTrimOrNullString((String)protocol);
        if (this.issuerRole == null || this.issuerProtocol == null) {
            throw new IllegalArgumentException("Issuer role and protocol may not be null");
        }
    }

    public SAMLSecurityPolicy(QName role, String protocol, boolean requireAuthenticatedIssuer) {
        super(requireAuthenticatedIssuer);
        this.issuerRole = role;
        this.issuerProtocol = DatatypeHelper.safeTrimOrNullString((String)protocol);
        if (this.issuerRole == null || this.issuerProtocol == null) {
            throw new IllegalArgumentException("Issuer role and protocol may not be null");
        }
    }

    public void evaluate(ServletRequest request, XMLObject message) throws SecurityPolicyException {
        super.evaluate(request, message);
        try {
            if (this.metadataProvider != null) {
                this.issuerRoleMetadata = this.metadataProvider.getRole(this.getIssuer(), this.issuerRole, this.issuerProtocol);
            }
        }
        catch (MetadataProviderException e) {
            this.log.warn((Object)("Could not look up role metadata for issuer " + this.getIssuer()), (Throwable)e);
        }
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    public RoleDescriptor getIssuerRoleMetadata() {
        return this.issuerRoleMetadata;
    }

    protected SecurityPolicyContext createNewContext() {
        SAMLSecurityPolicyContext context = new SAMLSecurityPolicyContext();
        context.setMetadataProvider(this.metadataProvider);
        context.setIssuerProtocol(this.issuerProtocol);
        context.setIssuerRole(this.issuerRole);
        return context;
    }
}

