/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.security.BaseSAMLSignatureSecurityPolicyRuleFactory;
import org.opensaml.common.binding.security.SAMLSecurityPolicyHelper;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLProtocolMessageXMLSignatureSecurityPolicyRuleFactory
extends BaseSAMLSignatureSecurityPolicyRuleFactory {
    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new SAMLProtocolMessageXMLSignatureSecurityPolicyRule((TrustEngine<Signature>)this.getTrustEngine());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SAMLProtocolMessageXMLSignatureSecurityPolicyRule
    extends BaseSAMLSignatureSecurityPolicyRuleFactory.BaseSAMLSignatureSecurityPolicyRule {
        private Logger log;

        public SAMLProtocolMessageXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
            super(engine);
            this.log = Logger.getLogger(SAMLProtocolMessageXMLSignatureSecurityPolicyRule.class);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            CriteriaSet criteriaSet;
            SAMLObject samlMsg = SAMLSecurityPolicyHelper.getSAMLMessage(message);
            if (samlMsg == null) {
                this.log.debug((Object)"Could not extract SAML message");
                return;
            }
            if (!(samlMsg instanceof SignableSAMLObject)) {
                this.log.debug((Object)"Extracted SAML message was not a SignableSAMLObject, can not process signature");
                return;
            }
            SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
            if (!signableObject.isSigned()) {
                this.log.info((Object)"SAML protocol message was not signed, skipping XML signature processing");
                return;
            }
            Signature signature = signableObject.getSignature();
            String contextIssuer = context.getIssuer();
            if (contextIssuer == null) {
                this.log.error((Object)"Context issuer unavailable, can not attempt SAML protocol message signature validation");
                throw new SecurityPolicyException("Context issuer unavailable, can not validate signature");
            }
            String msgType = signableObject.getElementQName().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to verify signature on signed SAML protocol message using context issuer, message type: " + msgType));
            }
            if (this.evaluate(signature, criteriaSet = this.buildCriteriaSet(context.getIssuer(), request, message, context))) {
                this.log.info((Object)("Validation of protocol message signature succeeded, message type: " + msgType));
                if (context.isIssuerAuthenticated() == Boolean.TRUE) return;
                this.log.info((Object)("Authentication via protocol message signature succeeded for context issuer entity ID '" + contextIssuer + "'"));
                context.setIssuerAuthenticated(true);
                return;
            }
            this.log.error((Object)("Validation of protocol message signature failed for context issuer '" + contextIssuer + "', message type: " + msgType));
            throw new SecurityPolicyException("Validation of protocol message signature failed");
        }
    }
}

