/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.provider.ClientCertAuthRule;
import org.opensaml.ws.security.provider.ClientCertAuthRuleFactory;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.X509Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLMDClientCertAuthRuleFactory
extends ClientCertAuthRuleFactory {
    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new SAMLMDClientCertAuthRule((TrustEngine<X509Credential>)this.getTrustEngine(), this.getCertificateNameOptions());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SAMLMDClientCertAuthRule
    extends ClientCertAuthRule {
        private Logger log;

        public SAMLMDClientCertAuthRule(TrustEngine<X509Credential> engine, ClientCertAuthRuleFactory.CertificateNameOptions nameOptions) {
            super(engine, nameOptions);
            this.log = Logger.getLogger(SAMLMDClientCertAuthRule.class);
        }

        protected CriteriaSet buildCriteriaSet(String entityID, ServletRequest request, XMLObject message, SecurityPolicyContext context) {
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                this.log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            CriteriaSet criteriaSet = super.buildCriteriaSet(entityID, request, message, context);
            MetadataCriteria mdCriteria = new MetadataCriteria(samlContext.getIssuerRole(), samlContext.getIssuerProtocol());
            criteriaSet.add((Object)mdCriteria);
            return criteriaSet;
        }
    }
}

