/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.provider.BaseTrustEngineRule;
import org.opensaml.ws.security.provider.BaseTrustEngineRuleFactory;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.EntityIDCriteria;
import org.opensaml.xml.security.credential.UsageCriteria;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSAMLSignatureSecurityPolicyRuleFactory
extends BaseTrustEngineRuleFactory<Signature, ServletRequest> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class BaseSAMLSignatureSecurityPolicyRule
    extends BaseTrustEngineRule<Signature, ServletRequest> {
        private Logger log;

        public BaseSAMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
            super(engine);
            this.log = Logger.getLogger(BaseSAMLSignatureSecurityPolicyRule.class);
        }

        protected CriteriaSet buildCriteriaSet(String entityID, ServletRequest request, XMLObject message, SecurityPolicyContext context) {
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                this.log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            CriteriaSet criteriaSet = new CriteriaSet();
            if (!DatatypeHelper.isEmpty((String)entityID)) {
                criteriaSet.add((Object)new EntityIDCriteria(entityID));
            }
            MetadataCriteria mdCriteria = new MetadataCriteria(samlContext.getIssuerRole(), samlContext.getIssuerProtocol());
            criteriaSet.add((Object)mdCriteria);
            criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
            return criteriaSet;
        }
    }
}

