/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.encoding.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.opensaml.Configuration;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.encoding.SOAPHTTPEncoder;
import org.opensaml.common.binding.encoding.impl.AbstractHTTPMessageEncoder;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Header;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSOAPHTTPEncoder
extends AbstractHTTPMessageEncoder
implements SOAPHTTPEncoder {
    private final Logger log = Logger.getLogger(AbstractSOAPHTTPEncoder.class);
    private Envelope soapMessage;
    private FastList<XMLObject> soapHeaders = new FastList();
    private String soapVersion = "1.1";

    @Override
    public Envelope getSOAPMessage() {
        return this.soapMessage;
    }

    protected void setSOAPMessage(Envelope message) {
        this.soapMessage = message;
    }

    @Override
    public List<XMLObject> getSOAPHeaders() {
        return this.soapHeaders;
    }

    @Override
    public String getSOAPVersion() {
        return this.soapVersion;
    }

    @Override
    public void setSOAPVersion(String version) {
        this.soapVersion = DatatypeHelper.isEmpty((String)version) ? "1.1" : version;
    }

    @Override
    public void encode() throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Beginning HTTP SOAP 1.1 encoding");
        }
        Envelope envelope = this.buildSOAPMessage();
        this.setSOAPMessage(envelope);
        String serialSoapMessage = this.marshallMessage((XMLObject)envelope);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Writting SOAP message to response");
            }
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            response.setHeader("SOAPAction", "http://www.oasis-open.org/committees/security");
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            this.initializeResponse();
            PrintWriter responseWriter = response.getWriter();
            responseWriter.write(serialSoapMessage);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to write response", (Throwable)e);
            throw new BindingException("Unable to write response", e);
        }
    }

    protected Envelope buildSOAPMessage() throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building SOAP message");
        }
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        List<XMLObject> headers = this.getSOAPHeaders();
        if (headers != null && headers.size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding " + headers.size() + " headers to the SOAP message"));
            }
            SOAPObjectBuilder headerBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Header.DEFAULT_ELEMENT_NAME);
            Header header = (Header)headerBuilder.buildObject();
            header.getUnknownXMLObjects().addAll(headers);
            envelope.setHeader(header);
        }
        if (this.getSamlMessage() == null) {
            this.log.error((Object)"No SAML message was set, unable to build SOAP body");
            throw new BindingException("No SAML message was set, unable to build SOAP body");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Adding SAML message to the SOAP message's body");
        }
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(this.getSamlMessage());
        envelope.setBody(body);
        return envelope;
    }
}

