/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.encoding.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.encoding.HTTPMessageEncoder;
import org.opensaml.common.binding.encoding.impl.AbstractMessageEncoder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPMessageEncoder
extends AbstractMessageEncoder<HttpServletResponse>
implements HTTPMessageEncoder {
    private String relayState;

    @Override
    public String getRelayState() {
        return this.relayState;
    }

    @Override
    public void setRelayState(String state) {
        this.relayState = state;
    }

    protected void initializeResponse() {
        ((HttpServletResponse)this.getResponse()).setCharacterEncoding("UTF-8");
        ((HttpServletResponse)this.getResponse()).addHeader("Cache-control", "no-cache, no-store");
        ((HttpServletResponse)this.getResponse()).addHeader("Pragma", "no-cache");
    }

    protected String getEncodeRelayState() throws BindingException {
        if (!DatatypeHelper.isEmpty((String)this.relayState)) {
            try {
                return URLEncoder.encode(this.relayState, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BindingException("VM does not support UTF-8 encoding");
            }
        }
        return null;
    }

    protected String getBase64EncodedMessage() throws BindingException {
        String messageXML = this.marshallMessage((XMLObject)this.getSamlMessage());
        return new String(Base64.encodeBytes((byte[])messageXML.getBytes(), (int)8));
    }
}

