/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.encoding;

import java.util.HashMap;
import java.util.Map;
import org.opensaml.common.binding.encoding.MessageEncoder;
import org.opensaml.common.binding.encoding.MessageEncoderBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEncoderFactory {
    private HashMap<String, MessageEncoderBuilder> encoderBuilders = new HashMap();

    public MessageEncoder getMessageEncoder(String binding) {
        MessageEncoderBuilder builder = this.encoderBuilders.get(binding);
        if (builder != null) {
            return builder.buildEncoder();
        }
        return null;
    }

    public Map<String, MessageEncoderBuilder> getEncoderBuilders() {
        return this.encoderBuilders;
    }

    public void setEncoderBuilders(Map<String, MessageEncoderBuilder> builders) {
        if (builders == null) {
            throw new IllegalArgumentException("Message encoder builders may not be null");
        }
        this.encoderBuilders.clear();
        this.encoderBuilders.putAll(builders);
    }
}

