/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.artifact;

import java.util.HashMap;
import java.util.Map;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.artifact.SAMLArtifact;
import org.opensaml.common.binding.artifact.SAMLArtifactBuilder;
import org.opensaml.saml1.binding.artifact.AbstractSAML1Artifact;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0001Builder;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0002Builder;
import org.opensaml.saml2.binding.artifact.AbstractSAML2Artifact;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004Builder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLArtifactFactory {
    private HashMap<String, SAMLArtifactBuilder<? extends AbstractSAML1Artifact>> saml1Builders = new HashMap();
    private HashMap<String, SAMLArtifactBuilder<? extends AbstractSAML2Artifact>> saml2Builders;

    public SAMLArtifactFactory() {
        this.saml1Builders.put(new String(SAML1ArtifactType0001.TYPE_CODE), new SAML1ArtifactType0001Builder());
        this.saml1Builders.put(new String(SAML1ArtifactType0002.TYPE_CODE), new SAML1ArtifactType0002Builder());
        this.saml2Builders = new HashMap();
        this.saml2Builders.put(new String(SAML2ArtifactType0004.TYPE_CODE), new SAML2ArtifactType0004Builder());
    }

    public SAMLArtifact buildArtifact(SAMLVersion samlVersion, byte[] artifactType, String relyingParty) throws BindingException {
        SAMLArtifactBuilder builder = this.getBuilder(samlVersion, artifactType);
        if (builder == null) {
            throw new BindingException("No SAML " + samlVersion.toString() + " artifact builder registered for type " + artifactType);
        }
        return builder.buildArtifact(relyingParty);
    }

    public SAMLArtifact buildArtifact(SAMLVersion samlVersion, byte[] artifact) throws BindingException {
        byte[] artifactType = new byte[]{artifact[0], artifact[1]};
        SAMLArtifactBuilder builder = this.getBuilder(samlVersion, artifactType);
        if (builder == null) {
            throw new BindingException("No SAML " + samlVersion.toString() + " artifact builder registered for type " + artifactType);
        }
        return builder.buildArtifact(artifact);
    }

    public Map<String, SAMLArtifactBuilder<? extends AbstractSAML1Artifact>> getSAML1ArtifactBuilders() {
        return this.saml1Builders;
    }

    public Map<String, SAMLArtifactBuilder<? extends AbstractSAML2Artifact>> getSAML2ArtifactBuilders() {
        return this.saml2Builders;
    }

    protected SAMLArtifactBuilder getBuilder(SAMLVersion samlVersion, byte[] artifactType) {
        String type = new String(artifactType);
        if (samlVersion == SAMLVersion.VERSION_10 || samlVersion == SAMLVersion.VERSION_11) {
            return this.saml1Builders.get(type);
        }
        if (samlVersion == SAMLVersion.VERSION_20) {
            return this.saml2Builders.get(type);
        }
        return null;
    }
}

