/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensaml.common.binding.AbstractEndpointSelector;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IndexedEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEndpointSelector
extends AbstractEndpointSelector {
    @Override
    public Endpoint selectEndpoint() {
        List<Endpoint> endpoints = this.getRelyingPartyRole().getEndpoints(this.getEndpointType());
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        if (endpoints.get(0) instanceof IndexedEndpoint) {
            return this.selectIndexedEndpoint(endpoints);
        }
        return this.selectNonIndexedEndpoint(endpoints);
    }

    protected Endpoint selectIndexedEndpoint(List<IndexedEndpoint> endpoints) {
        ArrayList<IndexedEndpoint> endpointsCopy = new ArrayList<IndexedEndpoint>(endpoints);
        Iterator endpointItr = endpointsCopy.iterator();
        IndexedEndpoint firstNoDefaultEndpoint = null;
        while (endpointItr.hasNext()) {
            IndexedEndpoint currentEndpoint = (IndexedEndpoint)endpointItr.next();
            if (!this.getSupportedIssuerBindings().contains(currentEndpoint.getBinding())) {
                endpointItr.remove();
                continue;
            }
            if (currentEndpoint.isDefault() == null) continue;
            if (currentEndpoint.isDefault().booleanValue()) {
                return currentEndpoint;
            }
            if (firstNoDefaultEndpoint != null) continue;
            firstNoDefaultEndpoint = currentEndpoint;
        }
        if (firstNoDefaultEndpoint != null) {
            return firstNoDefaultEndpoint;
        }
        if (endpointsCopy.size() > 0) {
            return (Endpoint)endpointsCopy.get(0);
        }
        return null;
    }

    protected Endpoint selectNonIndexedEndpoint(List<Endpoint> endpoints) {
        Iterator<Endpoint> endpointItr = endpoints.iterator();
        while (endpointItr.hasNext()) {
            Endpoint endpoint = endpointItr.next();
            if (!this.getSupportedIssuerBindings().contains(endpoint.getBinding())) {
                endpointItr.remove();
                continue;
            }
            return endpoint;
        }
        return null;
    }
}

