/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.common.binding.artifact.SAMLArtifactFactory;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLConfigurator;

public class DefaultBootstrap {
    private static Logger log = Logger.getLogger(DefaultBootstrap.class);
    private static String[] xmlToolingConfigs = new String[]{"/default-config.xml", "/schema-config.xml", "/signature-config.xml", "/encryption-config.xml", "/soap11-config.xml", "/saml1-assertion-config.xml", "/saml1-protocol-config.xml", "/saml1-core-validation-config.xml", "/saml2-assertion-config.xml", "/saml2-protocol-config.xml", "/saml2-protocol-thirdparty-config.xml", "/saml2-core-validation-config.xml", "/saml2-metadata-config.xml", "/saml1-metadata-config.xml", "/saml2-metadata-query-config.xml", "/saml2-metadata-validation-config.xml"};

    protected DefaultBootstrap() {
    }

    public static synchronized void bootstrap() throws ConfigurationException {
        DefaultBootstrap.initializeXMLSecurity();
        DefaultBootstrap.initializeVelocity();
        DefaultBootstrap.initializeXMLTooling(xmlToolingConfigs);
        DefaultBootstrap.initializeArtifactFactory();
    }

    protected static void initializeXMLSecurity() throws ConfigurationException {
        if (!Init.isInitialized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing Apache XMLSecurity library");
            }
            Init.init();
        }
    }

    protected static void initializeVelocity() throws ConfigurationException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing Velocity template engine");
            }
            Velocity.setProperty((String)"ISO-8859-1", (Object)"UTF-8");
            Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"resource.loader", (Object)"classpath");
            Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.init();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to initialize Velocity template engine", e);
        }
    }

    protected static void initializeXMLTooling(String[] providerConfigs) throws ConfigurationException {
        Class<Configuration> clazz = Configuration.class;
        XMLConfigurator configurator = new XMLConfigurator();
        for (String config : providerConfigs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading XMLTooling configuration " + config));
            }
            configurator.load(clazz.getResourceAsStream(config));
        }
    }

    protected static void initializeArtifactFactory() throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing SAML Artifact factory");
        }
        Configuration.setArtifactFactory(new SAMLArtifactFactory());
    }
}

