/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import net.noderunner.http.BasicHttpClient;
import net.noderunner.http.ClientRequest;
import net.noderunner.http.ClientResponse;
import net.noderunner.http.HttpClient;
import net.noderunner.http.HttpException;
import net.noderunner.http.IllegalHttpStateException;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.Method;
import net.noderunner.http.RequestLine;

public class RetryHttpClient
implements HttpClient {
    public static final int DEFAULT_MAX_TRIES = 3;
    private static SocketFactory sslSocketFactory;
    private final int maxTries;
    private URL url;
    private boolean open;
    private HttpClient client;
    private ClientRequest request;
    private boolean followRedirects;
    private boolean skipContinues;

    public RetryHttpClient(URL url, int maxTries) {
        if (url == null) {
            throw new IllegalArgumentException("Null URL");
        }
        if (maxTries < 1) {
            throw new IllegalArgumentException("Invalid number of retries");
        }
        this.url = url;
        this.maxTries = maxTries;
        this.followRedirects = true;
        this.skipContinues = true;
    }

    public RetryHttpClient(URL url) {
        this(url, 3);
    }

    protected void retrySendRequest(IOException e, int failures) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Socket makeSocket(URL url) throws IOException {
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        Socket s = new Socket(url.getHost(), port);
        s.setSoTimeout(30000);
        return s;
    }

    protected Socket makeSSLSocket(URL url) throws IOException {
        int port = url.getPort();
        if (port == -1) {
            port = 443;
        }
        if (sslSocketFactory == null) {
            sslSocketFactory = SSLSocketFactory.getDefault();
        }
        return sslSocketFactory.createSocket(url.getHost(), 443);
    }

    protected void setSocketOptions(Socket socket) throws IOException {
        socket.setSoTimeout(30000);
    }

    protected HttpClient makeHttpClient(URL url) throws IOException {
        Socket socket;
        String p = url.getProtocol();
        if ("http".equals(p)) {
            socket = this.makeSocket(url);
        } else if ("https".equals(p)) {
            socket = this.makeSSLSocket(url);
        } else {
            throw new IOException("Unknown protocol: " + url);
        }
        this.setSocketOptions(socket);
        return new BasicHttpClient(socket);
    }

    public void writeRequest(ClientRequest request) throws IOException {
        this.request = request;
        IOException lastException = null;
        int tries = 0;
        while (true) {
            if (!this.open) {
                this.client = this.makeHttpClient(this.url);
            }
            try {
                this.client.writeRequest(request);
                this.open = true;
                return;
            }
            catch (IOException e) {
                lastException = e;
                this.retrySendRequest(e, tries);
                if (tries++ < this.maxTries) continue;
                throw lastException;
            }
            break;
        }
    }

    public OutputStream getOutputStream() {
        if (!this.open) {
            throw new IllegalHttpStateException("Client not open");
        }
        return this.client.getOutputStream();
    }

    private boolean differentHost(URL newUrl) {
        return !newUrl.getHost().equals(this.url.getHost()) || newUrl.getPort() != this.url.getPort();
    }

    private void setupClientRequest(URL newUrl) {
        MessageHeaders headers = this.request.getHeaders();
        if (this.differentHost(newUrl)) {
            MessageHeader hh = MessageHeader.makeHostHeader(newUrl);
            headers.add(hh);
        }
        RequestLine rl = new RequestLine(this.request.getRequestLine().getMethod(), newUrl.getFile());
        this.request = new ClientRequest(rl, headers, this.request.getDataPoster());
        this.url = newUrl;
    }

    private boolean doingContinue(ClientResponse r) {
        if (!this.skipContinues) {
            return false;
        }
        return r.isContinue();
    }

    private boolean doingRedirect(ClientResponse r) throws IOException {
        URL newUrl;
        if (!this.followRedirects) {
            return false;
        }
        int code = r.getStatusLine().getStatusCode();
        if (code != 301 && code != 302 && code != 303 && code != 307) {
            return false;
        }
        String location = r.getHeaders().getFieldContent("location");
        if (location == null) {
            throw new HttpException("No location header in HTTP redirect");
        }
        location = location.trim();
        try {
            newUrl = new URL(this.url, location);
        }
        catch (MalformedURLException e) {
            throw new HttpException("Location header has invalid URL: " + location);
        }
        if (this.differentHost(newUrl)) {
            this.close();
        } else {
            r.readFully();
        }
        this.setupClientRequest(newUrl);
        return true;
    }

    private boolean closeConnection(ClientResponse r) {
        return r.getHeaders().contains(MessageHeader.MH_CONNECTION_CLOSE);
    }

    public ClientResponse readResponse() throws IOException {
        if (!this.open) {
            throw new IllegalHttpStateException("Client not open");
        }
        int tries = 0;
        IOException lastException = null;
        do {
            if (!this.open) {
                this.writeRequest(this.request);
            }
            try {
                Method m;
                ClientResponse r = this.client.readResponse();
                boolean bl = this.open = !this.closeConnection(r);
                if (this.doingContinue(r)) continue;
                if (this.request.getDataPoster() == null && ((m = this.request.getRequestLine().getMethod()) == Method.POST || m == Method.PUT)) {
                    return r;
                }
                if (!this.doingRedirect(r)) {
                    return r;
                }
                this.writeRequest(this.request);
            }
            catch (IOException e) {
                lastException = e;
                this.retrySendRequest(e, tries);
            }
        } while (tries++ < this.maxTries);
        if (lastException == null) {
            throw new HttpException("Redirected too many times: " + this.maxTries);
        }
        throw lastException;
    }

    public void close() throws IOException {
        if (this.open) {
            this.client.close();
        }
        this.open = false;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setSkipContinues(boolean skipContinues) {
        this.skipContinues = skipContinues;
    }

    public String toString() {
        return super.toString() + " maxTries=" + this.maxTries + " client=[" + this.client + "] url=" + this.url + " open=" + this.open;
    }
}

