/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.noderunner.http.HttpUtil;
import net.noderunner.http.MessageHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHeaders {
    private final List<MessageHeader> headers;

    public MessageHeaders(MessageHeader[] h) {
        this(new LinkedList<MessageHeader>(Arrays.asList(h)));
    }

    public MessageHeaders(List<MessageHeader> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("null headers");
        }
        this.headers = headers;
    }

    public MessageHeaders() {
        this(new ArrayList<MessageHeader>());
    }

    public static MessageHeaders defaultHeaders(URL url) {
        MessageHeaders mh = new MessageHeaders();
        mh.add(MessageHeader.MH_USER_AGENT);
        mh.add(MessageHeader.makeHostHeader(url));
        mh.add(MessageHeader.MH_CONNECTION_KEEP_ALIVE);
        return mh;
    }

    private static boolean lws(char c) {
        return c == ' ' || c == '\t';
    }

    public static MessageHeaders readHeaders(InputStream is) throws IOException {
        String line;
        ArrayList<MessageHeader> hl = new ArrayList<MessageHeader>();
        String curhead = null;
        while ((line = HttpUtil.readHttpLine(is)).length() != 0) {
            if (MessageHeaders.lws(line.charAt(0))) {
                if (curhead == null) {
                    throw new IOException("Malformed header: " + line);
                }
                curhead = curhead + line;
                continue;
            }
            if (curhead != null) {
                hl.add(MessageHeader.parse(curhead));
            }
            curhead = line;
        }
        if (curhead != null) {
            hl.add(MessageHeader.parse(curhead));
        }
        return new MessageHeaders(hl);
    }

    public void set(MessageHeader newHeader) {
        if (newHeader == null) {
            throw new IllegalArgumentException("null newHeader");
        }
        Iterator<MessageHeader> i = this.headers.iterator();
        while (i.hasNext()) {
            MessageHeader h = i.next();
            if (!h.getFieldName().equals(newHeader.getFieldName())) continue;
            i.remove();
        }
        this.headers.add(newHeader);
    }

    public void add(MessageHeader newHeader) {
        if (newHeader == null) {
            throw new IllegalArgumentException("null newHeader");
        }
        this.headers.add(newHeader);
    }

    public void add(String field, String value) {
        this.add(new MessageHeader(field, value));
    }

    public void set(String field, String value) {
        this.set(new MessageHeader(field, value));
    }

    public boolean remove(String fieldName) {
        fieldName = fieldName.toLowerCase(Locale.ENGLISH);
        boolean removed = false;
        Iterator<MessageHeader> i = this.headers.iterator();
        while (i.hasNext()) {
            MessageHeader h = i.next();
            if (!h.getFieldName().equals(fieldName)) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    public boolean contains(MessageHeader header) {
        return this.headers.contains(header);
    }

    public String getFieldContent(String fieldName) {
        fieldName = fieldName.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < this.headers.size(); ++i) {
            MessageHeader h = this.headers.get(i);
            if (!h.getFieldName().equals(fieldName)) continue;
            return h.getFieldContent();
        }
        return null;
    }

    public void write(Writer writer) throws IOException {
        for (int i = 0; i < this.headers.size(); ++i) {
            MessageHeader h = this.headers.get(i);
            writer.write(h.toString());
            writer.write("\r\n");
        }
    }

    public int count() {
        return this.headers.size();
    }

    public List<MessageHeader> asList() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<String> getNames() {
        ArrayList<String> nl = new ArrayList<String>(this.headers.size());
        for (MessageHeader h : this.headers) {
            nl.add(h.getFieldName());
        }
        return Collections.unmodifiableList(nl);
    }

    public String toString() {
        return this.headers.toString();
    }
}

