/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.noderunner.http.ChunkedInputStream;
import net.noderunner.http.HttpException;
import net.noderunner.http.LimitedInputStream;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    static final String CRLF = "\r\n";
    private static byte[] junk;
    private static final BitSet noencode;
    private static final byte[] hex;

    private HttpUtil() {
    }

    public static int readFully(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream");
        }
        if (junk == null) {
            junk = new byte[1024];
        }
        int total = 0;
        int got = 0;
        while ((got = stream.read(junk, 0, junk.length)) != -1) {
            total += got;
        }
        return total;
    }

    public static byte[] read(InputStream stream) throws IOException {
        byte[] b = new byte[128];
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        int got = 0;
        while ((got = stream.read(b, 0, b.length)) != -1) {
            bo.write(b, 0, got);
        }
        return bo.toByteArray();
    }

    public static InputStream wrapInputStream(InputStream stream, MessageHeaders hl) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream");
        }
        if (hl == null) {
            throw new IllegalArgumentException("Null headers");
        }
        boolean chunked = hl.contains(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
        if (chunked) {
            return new ChunkedInputStream(stream);
        }
        String s = hl.getFieldContent("content-length");
        if (s == null) {
            return stream;
        }
        try {
            int length = Integer.parseInt(s);
            return new LimitedInputStream(stream, length);
        }
        catch (NumberFormatException e) {
            throw new HttpException("content-length not a number:" + s);
        }
    }

    public static InputStream uncloseableInputStream(InputStream stream) throws IOException {
        return new FilterInputStream(stream){

            public void close() throws IOException {
            }
        };
    }

    public static String readHttpLine(InputStream in) throws IOException {
        StringBuilder sb;
        block4: {
            sb = new StringBuilder();
            int c = 0;
            do {
                if ((c = in.read()) == -1) {
                    throw new EOFException("EOF processing HTTP request");
                }
                if (c == 10) break block4;
                if (c == 13) {
                    c = in.read();
                    if (c != 10) {
                        throw new HttpException("Expected LN character reading HTTP information");
                    }
                    break block4;
                }
                sb.append((char)c);
            } while (sb.length() <= 1024);
            throw new HttpException("Header line too long");
        }
        return sb.toString();
    }

    public static byte[] urlEncode(String[] nvPairs, String encoding) throws UnsupportedEncodingException {
        if (nvPairs == null) {
            throw new IllegalArgumentException("Null array");
        }
        if (nvPairs.length % 2 != 0) {
            throw new IllegalArgumentException("Odd length array");
        }
        ByteArrayOutputStream bb = new ByteArrayOutputStream(16 * nvPairs.length);
        for (int i = 0; i < nvPairs.length; i += 2) {
            HttpUtil.appendNV(bb, nvPairs[i], nvPairs[i + 1], encoding);
        }
        return bb.toByteArray();
    }

    public static byte[] urlEncode(String[] nvPairs) {
        try {
            return HttpUtil.urlEncode(nvPairs, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("should not be here");
        }
    }

    public static void urlEncode(ByteArrayOutputStream os, byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            if (noencode.get(b)) {
                os.write(b);
                continue;
            }
            if (b == 32) {
                os.write(43);
                continue;
            }
            os.write(37);
            int low = b & 0xF;
            int high = (b & 0xF0) >> 4;
            os.write(hex[high]);
            os.write(hex[low]);
        }
    }

    private static void appendNV(ByteArrayOutputStream os, String n, String v, String enc) throws UnsupportedEncodingException {
        if (os.size() > 0) {
            os.write(38);
        }
        if (enc == null) {
            HttpUtil.urlEncode(os, n.getBytes());
        } else {
            HttpUtil.urlEncode(os, n.getBytes(enc));
        }
        if (v != null) {
            os.write(61);
            if (enc == null) {
                HttpUtil.urlEncode(os, v.getBytes());
            } else {
                HttpUtil.urlEncode(os, v.getBytes(enc));
            }
        }
    }

    public static byte[] urlEncode(Map<String, String> map, String encoding) throws UnsupportedEncodingException {
        if (map == null) {
            throw new IllegalArgumentException("Null map");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (Map.Entry<String, String> me : map.entrySet()) {
            HttpUtil.appendNV(os, me.getKey(), me.getValue(), encoding);
        }
        return os.toByteArray();
    }

    public static byte[] urlEncode(Map<String, String> map) {
        try {
            return HttpUtil.urlEncode(map, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("should not be here");
        }
    }

    private static String decode(String s) {
        return URLDecoder.decode(s);
    }

    private static int count(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String[] add(String[] sa, String s) {
        String[] sa2 = new String[sa.length + 1];
        System.arraycopy(sa, 0, sa2, 0, sa.length);
        sa2[sa.length] = s;
        return sa2;
    }

    private static void put(Map<String, String[]> map, String n, String v) {
        String[] sa = map.get(n);
        if (sa == null) {
            map.put(n, new String[]{v});
        } else {
            map.put(n, HttpUtil.add(sa, v));
        }
    }

    public static Map<String, String[]> urlDecode(String urlEncodedData) {
        if (urlEncodedData == null) {
            throw new IllegalArgumentException("Null urlEncodedData");
        }
        urlEncodedData = urlEncodedData.trim();
        StringTokenizer st = new StringTokenizer(urlEncodedData, "&=", true);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        while (st.hasMoreTokens()) {
            String n = st.nextToken();
            if (!st.hasMoreTokens()) {
                HttpUtil.put(map, HttpUtil.decode(n), "");
                break;
            }
            String eq = st.nextToken();
            if (!st.hasMoreTokens()) {
                HttpUtil.put(map, HttpUtil.decode(n), "");
                break;
            }
            if (eq.equals("&")) {
                HttpUtil.put(map, HttpUtil.decode(n), "");
                continue;
            }
            String v = st.nextToken();
            if (v.equals("&")) {
                HttpUtil.put(map, HttpUtil.decode(n), "");
                continue;
            }
            String dn = HttpUtil.decode(n);
            String dv = HttpUtil.decode(v);
            HttpUtil.put(map, dn, dv);
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        return map;
    }

    public static Map<String, String[]> urlDecode(InputStream is) throws IOException {
        byte[] bs = HttpUtil.read(is);
        return HttpUtil.urlDecode(new String(bs, "ASCII"));
    }

    public static String[] urlDecodeToArray(InputStream is) throws IOException {
        byte[] bs = HttpUtil.read(is);
        return HttpUtil.urlDecodeToArray(new String(bs, "ASCII"));
    }

    public static String[] urlDecodeToArray(String urlEncodedData) {
        if (urlEncodedData == null) {
            throw new IllegalArgumentException("Null urlEncodedData");
        }
        urlEncodedData = urlEncodedData.trim();
        StringTokenizer st = new StringTokenizer(urlEncodedData, "&=", true);
        int amps = HttpUtil.count(urlEncodedData, '&');
        String[] array = new String[(amps + 1) * 2];
        int i = -2;
        while (st.hasMoreTokens()) {
            String v;
            String n = st.nextToken();
            array[i += 2] = HttpUtil.decode(n);
            if (!st.hasMoreTokens()) break;
            String eq = st.nextToken();
            if (!st.hasMoreTokens()) break;
            if (eq.equals("&") || (v = st.nextToken()).equals("&")) continue;
            array[i + 1] = HttpUtil.decode(v);
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        return array;
    }

    public static void discard(BufferedReader r) throws IOException {
        if (r == null) {
            return;
        }
        while (r.readLine() != null) {
        }
    }

    public static String read(BufferedReader r) throws IOException {
        String line;
        if (r == null) {
            throw new IllegalArgumentException("null reader");
        }
        String sep = System.getProperty("line.separator", "\n");
        StringBuilder sb = new StringBuilder(128);
        while ((line = r.readLine()) != null) {
            sb.append(line).append(sep);
        }
        return sb.toString();
    }

    static {
        int i;
        junk = null;
        hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        noencode = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            noencode.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            noencode.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            noencode.set(i);
        }
        noencode.set(45);
        noencode.set(95);
        noencode.set(46);
        noencode.set(42);
    }
}

