/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.noderunner.http.ChunkedOutputStream;
import net.noderunner.http.DataPoster;
import net.noderunner.http.HttpException;
import net.noderunner.http.LimitedInputStream;

public class GeneralDataPoster
implements DataPoster {
    private static int DEFAULT_BUFFER_SIZE = 1024;
    private final InputStream is;
    private final int len;
    private final byte[] buf;
    private boolean sentOnce;

    public GeneralDataPoster(InputStream is, int len) {
        if (is == null && len != 0) {
            throw new IllegalArgumentException("Null InputStream with non-zero length");
        }
        this.is = is;
        this.len = len;
        this.buf = len > 0 && len < this.getDefaultBufferSize() ? new byte[len] : new byte[this.getDefaultBufferSize()];
    }

    public void sendData(OutputStream os) throws IOException {
        int got;
        if (os == null) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        if (this.len == 0) {
            return;
        }
        if (this.sentOnce) {
            if (!this.is.markSupported()) {
                throw new HttpException("Cannot re-post data");
            }
            this.is.reset();
        }
        this.sentOnce = true;
        if (this.is.markSupported()) {
            this.is.mark(this.len > 0 ? this.len : Integer.MAX_VALUE);
        }
        InputStream is2 = this.is;
        if (this.len < 0) {
            os = new ChunkedOutputStream(os);
        } else {
            is2 = new LimitedInputStream(this.is, this.len);
        }
        int sent = 0;
        while ((got = is2.read(this.buf)) != -1) {
            os.write(this.buf, 0, got);
            sent += got;
        }
        os.flush();
        if (os instanceof ChunkedOutputStream) {
            ((ChunkedOutputStream)os).doneOutput();
        }
        if (this.len > 0 && sent != this.len) {
            throw new HttpException("Expected " + this.len + " bytes, could send only " + sent);
        }
    }

    protected int getDefaultBufferSize() {
        return DEFAULT_BUFFER_SIZE;
    }

    public String toString() {
        return "GeneralDataPoster is=" + this.is + " len=" + this.len;
    }
}

