/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.noderunner.http.ByteArrayDataPoster;
import net.noderunner.http.ClientRequest;
import net.noderunner.http.ClientResponse;
import net.noderunner.http.GeneralDataPoster;
import net.noderunner.http.HttpClient;
import net.noderunner.http.HttpException;
import net.noderunner.http.HttpUtil;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.Method;
import net.noderunner.http.RequestLine;
import net.noderunner.http.Response;
import net.noderunner.http.RetryHttpClient;

public class EasyHttpClient {
    private final HttpClient client;
    private final MessageHeaders headers;
    private RequestLine requestLine;
    private ClientResponse lastResponse;
    private boolean checkStatus;

    public EasyHttpClient(HttpClient client, RequestLine requestLine, MessageHeaders headers) {
        if (client == null) {
            throw new IllegalArgumentException("Null client");
        }
        if (requestLine == null) {
            throw new IllegalArgumentException("Null requestLine");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Null headers");
        }
        this.client = client;
        this.requestLine = requestLine;
        this.headers = headers;
        this.checkStatus = true;
        this.lastResponse = null;
    }

    public EasyHttpClient(URL url, Method method) {
        this(EasyHttpClient.makeHttpClient(url), RequestLine.create(url, method), MessageHeaders.defaultHeaders(url));
    }

    public EasyHttpClient(HttpClient c, URL url, Method method) {
        this(c, RequestLine.create(url, method), MessageHeaders.defaultHeaders(url));
    }

    public EasyHttpClient(URL url) {
        this(url, Method.GET);
    }

    private static HttpClient makeHttpClient(URL url) {
        return new RetryHttpClient(url);
    }

    public void setFile(String fileName) {
        this.requestLine = new RequestLine(this.requestLine, fileName);
    }

    public void setMethod(Method method) {
        if (this.requestLine.getMethod().equals((Object)method)) {
            return;
        }
        this.requestLine = new RequestLine(method, this.requestLine.getRequestURI(), this.requestLine.getHttpVersion());
    }

    public MessageHeaders getHeaders() {
        return this.headers;
    }

    private InputStream readResponse2() throws IOException {
        int code;
        this.lastResponse = this.client.readResponse();
        if (this.checkStatus && (code = this.lastResponse.getStatusLine().getStatusCode()) / 100 != 2) {
            this.lastResponse.readFully();
            throw new HttpException("Bad HTTP Status, expected 200 level: " + this.lastResponse);
        }
        MessageHeaders hl = this.lastResponse.getHeaders();
        return HttpUtil.wrapInputStream(this.lastResponse.getInputStream(), hl);
    }

    private BufferedReader readResponse() throws IOException {
        InputStream s = this.readResponse2();
        if (s == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(s));
    }

    public void setCheckStatus(boolean checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public BufferedReader doGet() throws IOException {
        this.setMethod(Method.GET);
        this.client.writeRequest(new ClientRequest(this.requestLine, this.headers));
        this.client.getOutputStream();
        return this.readResponse();
    }

    private void setLenHeader(int len) {
        String slen = String.valueOf(len);
        MessageHeader mh = new MessageHeader("content-length", slen);
        this.headers.add(mh);
    }

    private void setContentType(String contentType) {
        if (contentType != null) {
            MessageHeader mh = new MessageHeader("content-type", contentType);
            this.headers.add(mh);
        }
    }

    private void setChunkedHeader() {
        this.headers.add(MessageHeader.MH_TRANSFER_ENCODING_CHUNKED);
    }

    public BufferedReader doPost(byte[] data, int off, int len, String contentType) throws IOException {
        this.setMethod(Method.POST);
        this.setLenHeader(len);
        this.setContentType(contentType);
        ByteArrayDataPoster p = new ByteArrayDataPoster(data, off, len);
        this.client.writeRequest(new ClientRequest(this.requestLine, this.headers, p));
        return this.readResponse();
    }

    public BufferedReader doPostUrlEncoded(byte[] urlEncodedData) throws IOException {
        if (urlEncodedData == null) {
            throw new IllegalArgumentException("null urlEncodedData");
        }
        this.headers.add(MessageHeader.MH_URL_ENCODED);
        return this.doPost(urlEncodedData, 0, urlEncodedData.length, null);
    }

    public void doOperation() throws IOException {
        this.doOperation(null, 0, null);
        this.lastResponse.readFully();
    }

    public InputStream doOperation(InputStream is, int len, String contentType) throws IOException {
        this.setContentType(contentType);
        if (len < 0) {
            this.setChunkedHeader();
        } else if (is != null) {
            this.setLenHeader(len);
        }
        GeneralDataPoster dataPoster = new GeneralDataPoster(is, len);
        this.client.writeRequest(new ClientRequest(this.requestLine, this.headers, dataPoster));
        return this.readResponse2();
    }

    public void close() throws IOException {
        this.client.close();
    }

    public String toString() {
        return "EasyHttpClient client=[" + this.client + "]";
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage:  EasyHttpClient URL ['post'] [post params]");
            System.err.println("  Performs an HTTP GET on the given URL");
            System.err.println("  If 'post' is indicated, does an HTTP POST with a string");
            System.err.println("  Else, if params are given, does an HTTP POST");
            System.err.println("  Post param format: a=b,c=d,e=f");
            return;
        }
        EasyHttpClient c = null;
        try {
            BufferedReader br;
            byte[] pp;
            if (args.length == 2) {
                c = new EasyHttpClient(new URL(args[0]), Method.POST);
                StringTokenizer st = new StringTokenizer(args[1], "=, ");
                HashMap<String, String> m = new HashMap<String, String>();
                while (st.hasMoreTokens()) {
                    m.put(st.nextToken(), st.nextToken());
                }
                pp = HttpUtil.urlEncode(m);
                System.err.println("Post body");
                System.err.println(new String(pp));
                br = c.doPostUrlEncoded(pp);
            } else if (args.length == 3) {
                c = new EasyHttpClient(new URL(args[0]), Method.POST);
                pp = args[2].getBytes();
                System.err.println("Post body");
                System.err.println(new String(pp));
                br = c.doPost(pp, 0, pp.length, "text/xml");
            } else {
                c = new EasyHttpClient(new URL(args[0]), Method.GET);
                br = c.doGet();
            }
            String s = HttpUtil.read(br);
            System.out.println(s);
            c.getLastResponse();
        }
        catch (Exception e) {
            System.err.println("Client failed: " + c);
            e.printStackTrace();
        }
    }
}

