/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.CollectionSchema;
import io.protostuff.Input;
import io.protostuff.MapSchema;
import io.protostuff.Message;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.HasDelegate;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.NumericIdStrategy;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public final class IncrementalIdStrategy
extends NumericIdStrategy {
    final ConcurrentHashMap<Class<?>, RuntimeCollectionFactory> collectionMapping;
    final ArrayList<RuntimeCollectionFactory> collections;
    final ConcurrentHashMap<Class<?>, RuntimeMapFactory> mapMapping;
    final ArrayList<RuntimeMapFactory> maps;
    final ConcurrentHashMap<Class<?>, RuntimeEnumIO> enumMapping;
    final ArrayList<RuntimeEnumIO> enums;
    final ConcurrentHashMap<Class<?>, BaseHS<?>> pojoMapping;
    final ArrayList<BaseHS<?>> pojos;
    final IdentityHashMap<Class<?>, NumericIdStrategy.RegisteredDelegate<?>> delegateMapping;
    final ArrayList<NumericIdStrategy.RegisteredDelegate<?>> delegates;
    final AtomicInteger pojoId;
    final AtomicInteger enumId;
    final AtomicInteger collectionId;
    final AtomicInteger mapId;
    final int pojoIdStart;
    final int enumIdStart;
    final int collectionIdStart;
    final int mapIdStart;

    public IncrementalIdStrategy(int collectionIdMax, int collectionIdStart, int mapIdMax, int mapIdStart, int enumIdMax, int enumIdStart, int pojoIdMax, int pojoIdStart) {
        this(DEFAULT_FLAGS, null, 0, collectionIdMax, collectionIdStart, mapIdMax, mapIdStart, enumIdMax, enumIdStart, pojoIdMax, pojoIdStart);
    }

    public IncrementalIdStrategy(int flags, IdStrategy primaryGroup, int groupId, int collectionIdMax, int collectionIdStart, int mapIdMax, int mapIdStart, int enumIdMax, int enumIdStart, int pojoIdMax, int pojoIdStart) {
        super(flags, primaryGroup, groupId);
        assert (collectionIdMax > collectionIdStart);
        assert (mapIdMax > mapIdStart);
        assert (enumIdMax > enumIdStart);
        assert (pojoIdMax > pojoIdStart);
        this.collectionIdStart = collectionIdStart;
        this.collectionId = new AtomicInteger(collectionIdStart);
        this.collectionMapping = new ConcurrentHashMap(collectionIdMax);
        this.collections = IncrementalIdStrategy.newList(collectionIdMax + 1);
        this.mapIdStart = mapIdStart;
        this.mapId = new AtomicInteger(mapIdStart);
        this.mapMapping = new ConcurrentHashMap(mapIdMax);
        this.maps = IncrementalIdStrategy.newList(mapIdMax + 1);
        this.enumIdStart = enumIdStart;
        this.enumId = new AtomicInteger(enumIdStart);
        this.enumMapping = new ConcurrentHashMap(enumIdMax);
        this.enums = IncrementalIdStrategy.newList(enumIdMax + 1);
        this.pojoIdStart = pojoIdStart;
        this.pojoId = new AtomicInteger(pojoIdStart);
        this.pojoMapping = new ConcurrentHashMap(pojoIdMax);
        this.pojos = IncrementalIdStrategy.newList(pojoIdMax + 1);
        this.delegateMapping = new IdentityHashMap(10);
        this.delegates = IncrementalIdStrategy.newList(11);
    }

    public boolean isRegistered(Class<?> typeClass) {
        BaseHS<?> hs = this.pojoMapping.get(typeClass);
        return hs != null && !(hs instanceof Lazy);
    }

    private <T> BaseHS<T> getBaseHS(Class<T> typeClass, boolean create) {
        BaseHS<?> hs = this.pojoMapping.get(typeClass);
        if (hs == null && create) {
            hs = new Lazy(typeClass, this);
            BaseHS<?> last = this.pojoMapping.putIfAbsent(typeClass, hs);
            if (last != null) {
                hs = last;
            } else {
                int id = this.pojoId.getAndIncrement();
                this.pojos.set(id, hs);
                hs.id = id;
            }
        }
        return hs;
    }

    public <T> HasSchema<T> getSchemaWrapper(Class<T> typeClass, boolean create) {
        return this.getBaseHS(typeClass, create);
    }

    private RuntimeEnumIO getRuntimeEnumIO(Class<?> enumClass) {
        RuntimeEnumIO reio = this.enumMapping.get(enumClass);
        if (reio == null) {
            reio = new RuntimeEnumIO();
            RuntimeEnumIO existing = this.enumMapping.putIfAbsent(enumClass, reio);
            if (existing != null) {
                reio = existing;
            } else {
                reio.eio = EnumIO.newEnumIO(enumClass, (IdStrategy)this);
                int id = this.enumId.getAndIncrement();
                this.enums.set(id, reio);
                reio.id = id;
            }
        }
        return reio;
    }

    protected EnumIO<? extends Enum<?>> getEnumIO(Class<?> enumClass) {
        return this.getRuntimeEnumIO(enumClass).eio;
    }

    private RuntimeCollectionFactory getRuntimeCollectionFactory(Class<?> clazz) {
        RuntimeCollectionFactory rfactory = this.collectionMapping.get(clazz);
        if (rfactory == null) {
            rfactory = new RuntimeCollectionFactory();
            RuntimeCollectionFactory f = this.collectionMapping.putIfAbsent(clazz, rfactory);
            if (f != null) {
                rfactory = f;
            } else {
                if (clazz.getName().startsWith("java.util") && CollectionSchema.MessageFactories.accept((String)clazz.getSimpleName())) {
                    rfactory.factory = CollectionSchema.MessageFactories.valueOf((String)clazz.getSimpleName());
                } else {
                    rfactory.instantiator = RuntimeEnv.newInstantiator(clazz);
                    rfactory.collectionClass = clazz;
                }
                int id = this.collectionId.getAndIncrement();
                this.collections.set(id, rfactory);
                rfactory.id = id;
            }
        }
        return rfactory;
    }

    protected CollectionSchema.MessageFactory getCollectionFactory(Class<?> clazz) {
        return this.getRuntimeCollectionFactory(clazz);
    }

    private RuntimeMapFactory getRuntimeMapFactory(Class<?> clazz) {
        RuntimeMapFactory rfactory = this.mapMapping.get(clazz);
        if (rfactory == null) {
            rfactory = new RuntimeMapFactory();
            RuntimeMapFactory f = this.mapMapping.putIfAbsent(clazz, rfactory);
            if (f != null) {
                rfactory = f;
            } else {
                if (clazz.getName().startsWith("java.util") && MapSchema.MessageFactories.accept((String)clazz.getSimpleName())) {
                    rfactory.factory = MapSchema.MessageFactories.valueOf((String)clazz.getSimpleName());
                } else {
                    rfactory.instantiator = RuntimeEnv.newInstantiator(clazz);
                    rfactory.mapClass = clazz;
                }
                int id = this.mapId.getAndIncrement();
                this.maps.set(id, rfactory);
                rfactory.id = id;
            }
        }
        return rfactory;
    }

    protected MapSchema.MessageFactory getMapFactory(Class<?> clazz) {
        return this.getRuntimeMapFactory(clazz);
    }

    protected void writeCollectionIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        int id;
        RuntimeCollectionFactory factory = this.getRuntimeCollectionFactory(clazz);
        while (0 == (id = factory.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
    }

    protected void transferCollectionId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    protected CollectionSchema.MessageFactory resolveCollectionFrom(Input input) throws IOException {
        RuntimeCollectionFactory factory;
        int id = input.readUInt32();
        RuntimeCollectionFactory runtimeCollectionFactory = factory = id < this.collections.size() ? this.collections.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("Unknown collection id: " + id);
        }
        return factory;
    }

    protected void writeMapIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        int id;
        RuntimeMapFactory factory = this.getRuntimeMapFactory(clazz);
        while (0 == (id = factory.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
    }

    protected void transferMapId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    protected MapSchema.MessageFactory resolveMapFrom(Input input) throws IOException {
        RuntimeMapFactory factory;
        int id = input.readUInt32();
        RuntimeMapFactory runtimeMapFactory = factory = id < this.maps.size() ? this.maps.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("Unknown map id: " + id);
        }
        return factory;
    }

    protected void writeEnumIdTo(Output output, int fieldNumber, Class<?> clazz) throws IOException {
        int id;
        RuntimeEnumIO reio = this.getRuntimeEnumIO(clazz);
        while (0 == (id = reio.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
    }

    protected void transferEnumId(Input input, Output output, int fieldNumber) throws IOException {
        output.writeUInt32(fieldNumber, input.readUInt32(), false);
    }

    protected EnumIO<?> resolveEnumFrom(Input input) throws IOException {
        RuntimeEnumIO reio;
        int id = input.readUInt32();
        RuntimeEnumIO runtimeEnumIO = reio = id < this.enums.size() ? this.enums.get(id) : null;
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("Unknown enum id: " + id);
        }
        return reio.eio;
    }

    public boolean isDelegateRegistered(Class<?> typeClass) {
        return this.delegateMapping.containsKey(typeClass);
    }

    public <T> Delegate<T> getDelegate(Class<? super T> typeClass) {
        NumericIdStrategy.RegisteredDelegate<?> rd = this.delegateMapping.get(typeClass);
        return rd == null ? null : rd.delegate;
    }

    public <T> HasDelegate<T> getDelegateWrapper(Class<? super T> typeClass) {
        return this.delegateMapping.get(typeClass);
    }

    protected <T> HasDelegate<T> tryWriteDelegateIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd = this.delegateMapping.get(clazz);
        if (rd == null) {
            return null;
        }
        output.writeUInt32(fieldNumber, rd.id, false);
        return rd;
    }

    protected <T> HasDelegate<T> transferDelegateId(Input input, Output output, int fieldNumber) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd;
        int id = input.readUInt32();
        NumericIdStrategy.RegisteredDelegate<?> registeredDelegate = rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        if (rd == null) {
            throw new IdStrategy.UnknownTypeException("delegate id: " + id + " (Outdated registry)");
        }
        output.writeUInt32(fieldNumber, id, false);
        return rd;
    }

    protected <T> HasDelegate<T> resolveDelegateFrom(Input input) throws IOException {
        NumericIdStrategy.RegisteredDelegate<?> rd;
        int id = input.readUInt32();
        NumericIdStrategy.RegisteredDelegate<?> registeredDelegate = rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        if (rd == null) {
            throw new IdStrategy.UnknownTypeException("delegate id: " + id + " (Outdated registry)");
        }
        return rd;
    }

    protected <T> HasSchema<T> tryWritePojoIdTo(Output output, int fieldNumber, Class<T> clazz, boolean registered) throws IOException {
        int id;
        BaseHS<T> wrapper = this.getBaseHS(clazz, false);
        if (wrapper == null || registered && !(wrapper instanceof Registered)) {
            return null;
        }
        while (0 == (id = wrapper.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
        return wrapper;
    }

    protected <T> HasSchema<T> writePojoIdTo(Output output, int fieldNumber, Class<T> clazz) throws IOException {
        int id;
        BaseHS<T> wrapper = this.getBaseHS(clazz, true);
        while (0 == (id = wrapper.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
        return wrapper;
    }

    protected <T> HasSchema<T> transferPojoId(Input input, Output output, int fieldNumber) throws IOException {
        BaseHS<?> wrapper;
        int id = input.readUInt32();
        BaseHS<?> baseHS = wrapper = id < this.pojos.size() ? this.pojos.get(id) : null;
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("unknown pojo id: " + id);
        }
        output.writeUInt32(fieldNumber, id, false);
        return wrapper;
    }

    protected <T> HasSchema<T> resolvePojoFrom(Input input, int fieldNumber) throws IOException {
        BaseHS<?> wrapper;
        int id = input.readUInt32();
        BaseHS<?> baseHS = wrapper = id < this.pojos.size() ? this.pojos.get(id) : null;
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("unknown pojo id: " + id);
        }
        return wrapper;
    }

    protected <T> Schema<T> writeMessageIdTo(Output output, int fieldNumber, Message<T> message) throws IOException {
        int id;
        BaseHS wrapper = (BaseHS)this.getSchemaWrapper(message.getClass(), true);
        while (0 == (id = wrapper.id)) {
            LockSupport.parkNanos(1L);
        }
        output.writeUInt32(fieldNumber, id, false);
        return message.cachedSchema();
    }

    @Override
    protected Class<?> collectionClass(int id) {
        RuntimeCollectionFactory factory;
        RuntimeCollectionFactory runtimeCollectionFactory = factory = id < this.collections.size() ? this.collections.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("Unknown collection id: " + id);
        }
        return factory.typeClass();
    }

    @Override
    protected Class<?> mapClass(int id) {
        RuntimeMapFactory factory;
        RuntimeMapFactory runtimeMapFactory = factory = id < this.maps.size() ? this.maps.get(id) : null;
        if (factory == null) {
            throw new IdStrategy.UnknownTypeException("Unknown map id: " + id);
        }
        return factory.typeClass();
    }

    @Override
    protected Class<?> enumClass(int id) {
        RuntimeEnumIO reio;
        RuntimeEnumIO runtimeEnumIO = reio = id < this.enums.size() ? this.enums.get(id) : null;
        if (reio == null) {
            throw new IdStrategy.UnknownTypeException("Unknown enum id: " + id);
        }
        return reio.eio.enumClass;
    }

    @Override
    protected Class<?> delegateClass(int id) {
        NumericIdStrategy.RegisteredDelegate<?> rd = id < this.delegates.size() ? this.delegates.get(id) : null;
        return rd == null ? null : rd.delegate.typeClass();
    }

    @Override
    protected Class<?> pojoClass(int id) {
        BaseHS<?> wrapper;
        BaseHS<?> baseHS = wrapper = id < this.pojos.size() ? this.pojos.get(id) : null;
        if (wrapper == null) {
            throw new IdStrategy.UnknownTypeException("Unknown pojo id: " + id);
        }
        return wrapper.getSchema().typeClass();
    }

    @Override
    protected NumericIdStrategy.RegisteredDelegate<?> getRegisteredDelegate(Class<?> clazz) {
        return this.delegateMapping.get(clazz);
    }

    @Override
    protected int getEnumId(Class<?> clazz) {
        int id;
        RuntimeEnumIO reio = this.getRuntimeEnumIO(clazz);
        while (0 == (id = reio.id)) {
            LockSupport.parkNanos(1L);
        }
        return id << 5 | 0x19;
    }

    @Override
    protected int getId(Class<?> clazz) {
        int id;
        if (Message.class.isAssignableFrom(clazz)) {
            int id2;
            BaseHS<?> wrapper = this.getBaseHS(clazz, true);
            while (0 == (id2 = wrapper.id)) {
                LockSupport.parkNanos(1L);
            }
            return id2 << 5 | 0x1C;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            int id3;
            if (EnumMap.class.isAssignableFrom(clazz)) {
                return 24;
            }
            RuntimeMapFactory factory = this.getRuntimeMapFactory(clazz);
            while (0 == (id3 = factory.id)) {
                LockSupport.parkNanos(1L);
            }
            return id3 << 5 | 0x1B;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            int id4;
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return 23;
            }
            RuntimeCollectionFactory factory = this.getRuntimeCollectionFactory(clazz);
            while (0 == (id4 = factory.id)) {
                LockSupport.parkNanos(1L);
            }
            return id4 << 5 | 0x1A;
        }
        BaseHS<?> wrapper = this.getBaseHS(clazz, true);
        while (0 == (id = wrapper.id)) {
            LockSupport.parkNanos(1L);
        }
        return id << 5 | 0x1C;
    }

    static final class Lazy<T>
    extends LazyRegister<T> {
        Lazy(Class<T> typeClass, IdStrategy strategy) {
            super(typeClass, strategy);
        }
    }

    static class LazyRegister<T>
    extends BaseHS<T> {
        final Class<T> typeClass;
        private volatile Schema<T> schema;
        private volatile Pipe.Schema<T> pipeSchema;

        LazyRegister(Class<T> typeClass, IdStrategy strategy) {
            super(strategy);
            this.typeClass = typeClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Schema<T> getSchema() {
            Schema schema = this.schema;
            if (schema == null) {
                LazyRegister lazyRegister = this;
                synchronized (lazyRegister) {
                    schema = this.schema;
                    if (schema == null) {
                        if (Message.class.isAssignableFrom(this.typeClass)) {
                            Message m = (Message)IdStrategy.createMessageInstance(this.typeClass);
                            this.schema = schema = m.cachedSchema();
                        } else {
                            this.schema = schema = this.strategy.newSchema(this.typeClass);
                        }
                    }
                }
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pipe.Schema<T> getPipeSchema() {
            Pipe.Schema pipeSchema = this.pipeSchema;
            if (pipeSchema == null) {
                LazyRegister lazyRegister = this;
                synchronized (lazyRegister) {
                    pipeSchema = this.pipeSchema;
                    if (pipeSchema == null) {
                        this.pipeSchema = pipeSchema = RuntimeSchema.resolvePipeSchema(this.getSchema(), this.typeClass, (boolean)true);
                    }
                }
            }
            return pipeSchema;
        }
    }

    static final class Registered<T>
    extends BaseHS<T> {
        final Schema<T> schema;
        final Pipe.Schema<T> pipeSchema;

        Registered(int id, Schema<T> schema, Pipe.Schema<T> pipeSchema, IdStrategy strategy) {
            super(strategy);
            this.id = id;
            this.schema = schema;
            this.pipeSchema = pipeSchema;
        }

        public Schema<T> getSchema() {
            return this.schema;
        }

        public Pipe.Schema<T> getPipeSchema() {
            return this.pipeSchema;
        }
    }

    static abstract class BaseHS<T>
    extends HasSchema<T> {
        volatile int id;

        protected BaseHS(IdStrategy strategy) {
            super(strategy);
        }
    }

    static final class RuntimeEnumIO {
        volatile int id;
        EnumIO<?> eio;

        RuntimeEnumIO() {
        }
    }

    static final class RuntimeMapFactory
    implements MapSchema.MessageFactory {
        volatile int id;
        MapSchema.MessageFactory factory;
        Class<?> mapClass;
        RuntimeEnv.Instantiator<?> instantiator;

        RuntimeMapFactory() {
        }

        public <K, V> Map<K, V> newMessage() {
            if (this.factory == null) {
                return (Map)this.instantiator.newInstance();
            }
            return this.factory.newMessage();
        }

        public Class<?> typeClass() {
            return this.factory == null ? this.mapClass : this.factory.typeClass();
        }
    }

    static final class RuntimeCollectionFactory
    implements CollectionSchema.MessageFactory {
        volatile int id;
        CollectionSchema.MessageFactory factory;
        Class<?> collectionClass;
        RuntimeEnv.Instantiator<?> instantiator;

        RuntimeCollectionFactory() {
        }

        public <V> Collection<V> newMessage() {
            if (this.factory == null) {
                return (Collection)this.instantiator.newInstance();
            }
            return this.factory.newMessage();
        }

        public Class<?> typeClass() {
            return this.factory == null ? this.collectionClass : this.factory.typeClass();
        }
    }

    public static class Registry
    implements NumericIdStrategy.Registry {
        public final IncrementalIdStrategy strategy;

        public Registry(int collectionIdMax, int collectionIdStart, int mapIdMax, int mapIdStart, int enumIdMax, int enumIdStart, int pojoIdMax, int pojoIdStart) {
            this(IdStrategy.DEFAULT_FLAGS, null, 0, collectionIdMax, collectionIdStart, mapIdMax, mapIdStart, enumIdMax, enumIdStart, pojoIdMax, pojoIdStart);
        }

        public Registry(int flags, IdStrategy primaryGroup, int groupId, int collectionIdMax, int collectionIdStart, int mapIdMax, int mapIdStart, int enumIdMax, int enumIdStart, int pojoIdMax, int pojoIdStart) {
            this.strategy = new IncrementalIdStrategy(flags, primaryGroup, groupId, collectionIdMax, collectionIdStart, mapIdMax, mapIdStart, enumIdMax, enumIdStart, pojoIdMax, pojoIdStart);
        }

        @Override
        public <T extends Collection<?>> Registry registerCollection(CollectionSchema.MessageFactory factory, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("collection ids start at 1.");
            }
            if (id >= this.strategy.collectionIdStart) {
                throw new IllegalArgumentException("collection ids must be lesser than " + this.strategy.collectionIdStart);
            }
            if (this.strategy.collections.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + factory.typeClass() + ")");
            }
            RuntimeCollectionFactory rf = new RuntimeCollectionFactory();
            rf.id = id;
            rf.factory = factory;
            this.strategy.collections.set(id, rf);
            if (this.strategy.collectionMapping.put(factory.typeClass(), rf) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + factory.typeClass());
            }
            return this;
        }

        @Override
        public <T extends Map<?, ?>> Registry registerMap(MapSchema.MessageFactory factory, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("map ids start at 1.");
            }
            if (id >= this.strategy.mapIdStart) {
                throw new IllegalArgumentException("map ids must be lesser than " + this.strategy.mapIdStart);
            }
            if (this.strategy.maps.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + factory.typeClass() + ")");
            }
            RuntimeMapFactory rf = new RuntimeMapFactory();
            rf.id = id;
            rf.factory = factory;
            this.strategy.maps.set(id, rf);
            if (this.strategy.mapMapping.put(factory.typeClass(), rf) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + factory.typeClass());
            }
            return this;
        }

        @Override
        public <T extends Enum<T>> Registry registerEnum(Class<T> clazz, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("enum ids start at 1.");
            }
            if (id >= this.strategy.enumIdStart) {
                throw new IllegalArgumentException("enum ids must be lesser than " + this.strategy.enumIdStart);
            }
            if (this.strategy.enums.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + clazz.getName() + ")");
            }
            EnumIO eio = EnumIO.newEnumIO(clazz, (IdStrategy)this.strategy);
            RuntimeEnumIO reio = new RuntimeEnumIO();
            reio.id = id;
            reio.eio = eio;
            this.strategy.enums.set(id, reio);
            if (this.strategy.enumMapping.put(clazz, reio) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + clazz);
            }
            return this;
        }

        @Override
        public Registry registerEnum(EnumIO<?> eio, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("enum ids start at 1.");
            }
            if (id >= this.strategy.enumIdStart) {
                throw new IllegalArgumentException("enum ids must be lesser than " + this.strategy.enumIdStart);
            }
            if (this.strategy.enums.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + eio.enumClass.getName() + ")");
            }
            RuntimeEnumIO reio = new RuntimeEnumIO();
            reio.id = id;
            reio.eio = eio;
            this.strategy.enums.set(id, reio);
            if (this.strategy.enumMapping.put(eio.enumClass, reio) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + eio.enumClass);
            }
            return this;
        }

        @Override
        public <T> Registry registerPojo(Class<T> clazz, int id) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                throw new IllegalArgumentException("Not a concrete class: " + clazz);
            }
            if (id < 1) {
                throw new IllegalArgumentException("pojo ids start at 1.");
            }
            if (id >= this.strategy.pojoIdStart) {
                throw new IllegalArgumentException("pojo ids must be lesser than " + this.strategy.pojoIdStart);
            }
            if (this.strategy.pojos.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + clazz.getName() + ")");
            }
            if (this.strategy.pojoMapping.containsKey(clazz)) {
                throw new IllegalArgumentException("Duplicate registration for: " + clazz);
            }
            LazyRegister<T> wrapper = new LazyRegister<T>(clazz, this.strategy);
            wrapper.id = id;
            this.strategy.pojos.set(id, wrapper);
            this.strategy.pojoMapping.put(clazz, wrapper);
            return this;
        }

        @Override
        public <T> Registry registerPojo(Schema<T> schema, Pipe.Schema<T> pipeSchema, int id) {
            if (id >= this.strategy.pojoIdStart) {
                throw new IllegalArgumentException("pojo ids must be lesser than " + this.strategy.pojoIdStart);
            }
            if (this.strategy.pojos.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + schema.typeClass().getName() + ")");
            }
            if (this.strategy.pojoMapping.containsKey(schema.typeClass())) {
                throw new IllegalArgumentException("Duplicate registration for: " + schema.typeClass());
            }
            Registered<T> wrapper = new Registered<T>(id, schema, pipeSchema, this.strategy);
            this.strategy.pojos.set(id, wrapper);
            this.strategy.pojoMapping.put(schema.typeClass(), wrapper);
            return this;
        }

        @Override
        public <T> Registry mapPojo(Class<? super T> baseClass, Class<T> implClass) {
            if (this.strategy.pojoMapping.containsKey(baseClass)) {
                throw new IllegalArgumentException("Duplicate registration for: " + baseClass);
            }
            BaseHS<?> wrapper = this.strategy.pojoMapping.get(implClass);
            if (wrapper == null) {
                throw new IllegalArgumentException("Must register the impl class first. " + implClass);
            }
            this.strategy.pojoMapping.put(baseClass, wrapper);
            return this;
        }

        @Override
        public <T> Registry registerDelegate(Delegate<T> delegate, int id) {
            if (id < 1) {
                throw new IllegalArgumentException("delegate ids start at 1.");
            }
            if (id >= this.strategy.delegates.size()) {
                NumericIdStrategy.grow(this.strategy.delegates, id + 1);
            } else if (this.strategy.delegates.get(id) != null) {
                throw new IllegalArgumentException("Duplicate id registration: " + id + " (" + delegate.typeClass() + ")");
            }
            NumericIdStrategy.RegisteredDelegate<T> rd = new NumericIdStrategy.RegisteredDelegate<T>(id, delegate, this.strategy);
            this.strategy.delegates.set(id, rd);
            if (this.strategy.delegateMapping.put(delegate.typeClass(), rd) != null) {
                throw new IllegalArgumentException("Duplicate registration for: " + delegate.typeClass());
            }
            return this;
        }
    }

    public static class Factory
    implements IdStrategy.Factory {
        public IdStrategy create() {
            return new IncrementalIdStrategy(CollectionSchema.MessageFactories.values().length, 1, MapSchema.MessageFactories.values().length, 1, 16, 1, 64, 1);
        }

        public void postCreate() {
        }
    }
}

